% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_bulk.R
\name{get_eurostat_bulk}
\alias{get_eurostat_bulk}
\title{Get Eurostat data in a standardized format}
\usage{
get_eurostat_bulk(id, cache = TRUE, update_cache = FALSE,
  cache_dir = NULL, compress_file = TRUE,
  stringsAsFactors = default.stringsAsFactors(), select_freq = NULL,
  keep_flags = FALSE, verbose = FALSE, ...)
}
\arguments{
\item{id}{A code name for the dataset of interest.
See \code{\link{search_eurostat_toc}} for details how to get an id.}

\item{cache}{a logical whether to do caching. Default is \code{TRUE}.}

\item{update_cache}{a logical with a default value \code{FALSE}, whether to update cache. Can be set also with
\code{options(restatapi_update = TRUE)}}

\item{cache_dir}{a path to a cache directory. The \code{NULL} (default) uses the memory as cache. 
If the folder  if the \code{cache_dir} directory does not exist it saves in the 'restatapi' directory 
under the temporary directory from \code{tempdir()}. Directory can also be set with
\code{option(restatapi_cache_dir=...)}.}

\item{compress_file}{a logical whether to compress the
RDS-file in caching. Default is \code{TRUE}.}

\item{stringsAsFactors}{if \code{TRUE} (the default) variables are not numeric then they are
converted to factors. If the value \code{FALSE}
they are returned as a characters.}

\item{select_freq}{a character symbol for a time frequency when a dataset has multiple time
frequencies. Possible values are:
  A = annual, S = semi-annual, Q = quarterly, M = monthly. 
  The default is \code{NULL} as most datasets have just one time
frequency and in this case if there are multiple frequencies, then only the most common frequency kept.
If all the frequencies needed the \code{\link{get_eurostat_raw}} can be used.}

\item{keep_flags}{a logical whether the observation status (flags) - e.g. "confidential",
"provisional", etc. - should be kept in a separate column or if they
can be removed. Default is \code{FALSE}. For flag values see: 
\url{http://ec.europa.eu/eurostat/data/database/information}.}

\item{verbose}{A boolean with default \code{FALSE}, so detailed messages (for debugging) will not printed.
Can be set also with \code{options(restatapi_verbose=TRUE)}}

\item{...}{parameter to pass on the \code{\link{load_cfg}} function}
}
\value{
a data.table. One column for each dimension in the data,
        the time column for a time dimension, 
        the values column for numerical values and the flags column if the \code{keep_flags=TRUE}.
        Eurostat data does not include all missing values. The missing values are dropped if all dimensions are missing
        on particular time.
}
\description{
Download data sets from \href{https://ec.europa.eu/eurostat/}{Eurostat} database and put in a standardized format.
}
\details{
Data sets are downloaded from \href{http://ec.europa.eu/eurostat/estat-navtree-portlet-prod/BulkDownloadListing}{the Eurostat bulk download facility} 
in SDMX format and filtered for a unique time frequency.
If no frequency is selected and there are multiple frequencies in the dataset, then the most common value is used.

Compared to \code{\link{get_eurostat_raw}} the frequency column is removed  
and the original column names for the time period, observation values and status are renamed to "time", "values" and "flags".

By default all datasets cached as they are often rather large. 
The datasets cached in memory (default) or can be stored in a temporary directory if \code{cache_dir} or \code{option(restatpi_cache_dir)} is defined.
The cache can be emptied with \code{\link{clean_restatapi_cache}}.

The \code{id}, is a value from the \code{code} column of the table of contents (\code{\link{get_eurostat_toc}}), and can be searched for with the \code{\link{search_eurostat_toc}} function. The id value can be retrieved from the \href{http://ec.europa.eu/eurostat/data/database}{Eurostat database}
 as well. The Eurostat
database gives codes in the Data Navigation Tree after every dataset
in parenthesis.
}
\examples{
\dontshow{
options(mc.cores=min((parallel::detectCores()),2))
}
\donttest{
dt<-get_eurostat_bulk("agr_r_milkpr",keep_flags=TRUE)
options(restatapi_update=TRUE)
dt<-get_eurostat_bulk("avia_par_ee")
dt<-get_eurostat_bulk("avia_par_ee",select_freq="A",verbose=TRUE)
options(restatapi_update=FALSE)
dt<-get_eurostat_bulk("agr_r_milkpr",cache_dir=tempdir(),compress_file=FALSE,verbose=TRUE)
}
}
\seealso{
\code{\link{get_eurostat_data}}, \code{\link{get_eurostat_raw}}
}
