% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval.R
\name{interval-operations}
\alias{interval-operations}
\alias{interval_union}
\alias{interval_intersection}
\title{Convex union and intersection of intervals}
\usage{
interval_union(..., intervals = list())

interval_intersection(..., intervals = list())
}
\arguments{
\item{...}{appened to \code{intervals} if present.}

\item{intervals}{A list of \code{Interval}s.}
}
\value{
\code{interval_union} returns the convex union of all intervals in \code{intervals}.
This is the smallest interval completely containing all intervals.

\code{interval_intersection} returns the set intersection of all intervals in
\code{intervals}. The empty set is represented by the open interval (0, 0).
}
\description{
Convex union and intersection of intervals
}
\examples{
interval_union(
  interval(c(0, 1), closed = TRUE),
  interval(c(1, 2))
)

interval_union(
  interval(c(0, 5)),
  interval(c(1, 4), closed = TRUE)
)

# Convex union is not equal to set union:
interval_union(
  interval(c(0, 1)),
  interval(c(2, 3))
)

# The empty union is {}
interval_union()

interval_intersection(
  interval(c(0, 1)),
  interval(c(0.5, 2))
)

interval_intersection(
  interval(c(0, Inf)),
  interval(c(-Inf, 0))
)

interval_intersection(
  interval(c(0, Inf), include_lowest = TRUE),
  interval(c(-Inf, 0), include_highest = TRUE)
)

interval_intersection(
  interval(c(0, 5)),
  interval(c(1, 6), closed = TRUE)
)

# The empty intersection is (-Inf, Inf)
interval_intersection()
}
\seealso{
interval
}
