% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods_reservoir_predict_seq.R
\name{summary.reservoir_predict_seq}
\alias{summary.reservoir_predict_seq}
\title{summary.reservoir_predict_seq}
\usage{
\method{summary}{reservoir_predict_seq}(object, ...)
}
\arguments{
\item{object}{A reservoir_predict_seq object}

\item{...}{Additional argument (unused)}
}
\value{
A dataframe with node activation
}
\description{
summary.reservoir_predict_seq
}
\examples{
if(reticulate::py_module_available("reservoirpy")){
reservoir <- reservoirnet::createNode(nodeType = "Reservoir",
                                      seed = 1,
                                      units = 100,
                                      lr = 0.7,
                                      sr = 1,
                                      input_scaling = 1)
X <- matrix(data = rnorm(100), ncol = 4)
reservoir_state_stand <- reservoirnet::predict_seq(node = reservoir, X = X)
plot(reservoir_state_stand)
summary(reservoir_state_stand)
}

}
