% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marginal_perf.R
\name{plot_marginal_perf}
\alias{plot_marginal_perf}
\title{plot_marginal_perf}
\usage{
plot_marginal_perf(dfPerf, color_cut = 10, perf_lab = "Median relative error")
}
\arguments{
\item{dfPerf}{The performance dataframe which should have the columns : perf, ridge, input_scaling, leaking_rate, spectral_radius. Where perf is the performance metric}

\item{color_cut}{The cutting point to highlight best values (default = 10)}

\item{perf_lab}{The label of the performance metric.}
}
\value{
A plot with 4 facets
}
\description{
get marginal performance from dfPerf
}
\examples{
dfPerf <-
data.frame(
  perf = runif(n = 10),
  ridge = runif(n = 10),
  input_scaling = runif(n = 10),
  leaking_rate = runif(n = 10)
)
reservoirnet::plot_marginal_perf(dfPerf = dfPerf, color_cut = 2)

}
