% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_genes.R
\name{computeHVG}
\alias{computeHVG}
\title{Compute Highly Variable Genes}
\usage{
computeHVG(
  expression_matrix,
  reverse_log_scale = T,
  log_base = exp(1),
  expression_threshold = 0,
  nr_expression_groups = 20,
  zscore_threshold = 1.5
)
}
\arguments{
\item{expression_matrix}{Expression matrix}

\item{reverse_log_scale}{Reverse log-scale of expression values}

\item{log_base}{If reverse_log_scale is TRUE, which log base was used?}

\item{expression_threshold}{Expression threshold to consider a gene detected}

\item{nr_expression_groups}{Number of expression groups for cov_groups}

\item{zscore_threshold}{Z-score to select hvg for cov_groups}
}
\value{
Character vector of highly variable genes
}
\description{
Compute Highly Variable Genes
}
\examples{
set.seed(0)
requireNamespace("Matrix")

## generate (meaningless) counts
c1 <- stats::rpois(5e3, 1)
c2 <- stats::rpois(5e3, 2)
m <- t(
  rbind(
    matrix(c1, nrow = 20),
    matrix(c2, nrow = 20)
  )
)

## construct an expression matrix m
colnames(m) <- paste0('cell', 1:ncol(m))
rownames(m) <- paste0('gene', 1:nrow(m))
m <- log(m/colSums(m)*1e4 + 1)
m <- methods::as(m, 'dgCMatrix')

## calculate HVGs
hvgs <- computeHVG(m)

}
