% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_setup.R
\name{cache_setup}
\alias{cache_setup}
\alias{cache_info}
\title{Setup cache path}
\usage{
cache_setup(full_path = NULL, temp_dir = FALSE)

cache_info()
}
\arguments{
\item{full_path}{(character) the full path to use for storing cached
files.}

\item{temp_dir}{(logical) if \code{TRUE} use a randomly assigned
\code{tempdir} (and \code{full_path} is ignored), if \code{FALSE}, you
can use \code{full_path}.}
}
\value{
the full cache path, a directory (character)
}
\description{
Setup cache path
}
\details{
On opening,  by default a temporary directory is created for caching
files.  To have files cached elsewhere,  give the full path of where to
cache files.  Adding \code{temp_dir = TRUE} will again use a temporary
dirctory for cacheing.
}
\examples{
\dontrun{
# default path
cache_setup()

# you can define your own path
cache_setup(path = "foobar")

# set a tempdir - better for programming with to avoid prompt
cache_setup(temp_dir = TRUE)

# cache info
cache_info()
}
}
\seealso{
Other cache: 
\code{\link{cache_delete}()},
\code{\link{cache_details}()},
\code{\link{cache_list}()}
}
\concept{cache}
