% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{browse}
\alias{browse}
\title{Browse a dataset webpage.}
\usage{
browse(x, url = eurl(), ...)
}
\arguments{
\item{x}{datasetid or an object associated with a datasetid such
\code{\link[=info]{info()}}, \code{\link[=griddap]{griddap()}} or \code{\link[=tabledap]{tabledap()}}}

\item{url}{A URL for an ERDDAP server. Default:
\url{https://upwell.pfeg.noaa.gov/erddap/}. See \code{\link[=eurl]{eurl()}} for
more information}

\item{...}{Further args passed on to \code{utils::browseURL}
(must be a named parameter)}
}
\value{
if in interactive mode, opens a URL in your default browser;
if not, then prints the URL in the console
}
\description{
Note that it is an error to call this when \code{base::interactive()}
returns \code{FALSE}
}
\examples{
\dontrun{
# browse by dataset_id
browse('erdATastnhday')

# browse info class
my_info <- info('erdATastnhday')
browse(my_info)

# browse tabledap class
my_tabledap <- tabledap('erdCalCOFIlrvsiz', fields=c('latitude','longitude','larvae_size',
   'itis_tsn'), 'time>=2011-10-25', 'time<=2011-10-31')
browse(my_tabledap)
}
}
\author{
Ben Tupper \email{btupper@bigelow.org}
}
