% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse.R
\name{browse}
\alias{browse}
\title{Browse a dataset webpage.}
\usage{
browse(x, url = eurl(), ...)
}
\arguments{
\item{x}{datasetid or an object associated with a datasetid such
\code{\link{info}}, \code{\link{griddap}} or \code{\link{tabledap}}}

\item{url}{A URL for an ERDDAP server. Default:
\url{https://upwell.pfeg.noaa.gov/erddap/}}

\item{...}{Further args passed on to \code{\link[httr]{BROWSE}}
(must be a named parameter)}
}
\value{
the value returned by \code{\link[httr]{BROWSE}}
}
\description{
Note that it is an error to call this when \code{base::interactive()}
returns \code{FALSE}
}
\examples{
\dontrun{
# browse by dataset_id
browse('erdATastnhday')

# browse info class
my_info <- info('erdATastnhday')
browse(my_info)

# browse tabledap class
my_tabledap <- tabledap('erdCalCOFIfshsiz')
browse(my_tabledap)
}
}
\author{
Ben Tupper \email{btupper@bigelow.org}
}
