% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/search_adv.R
\name{ed_search_adv}
\alias{ed_search_adv}
\title{Advanced search for ERDDAP tabledep or griddap datasets}
\usage{
ed_search_adv(query = NULL, page = 1, page_size = 1000, protocol = NULL,
  cdm_data_type = NULL, institution = NULL, ioos_category = NULL,
  keywords = NULL, long_name = NULL, standard_name = NULL,
  variableName = NULL, maxLat = NULL, minLon = NULL, maxLon = NULL,
  minLat = NULL, minTime = NULL, maxTime = NULL, url = eurl(), ...)
}
\arguments{
\item{query}{(character) Search terms}

\item{page}{(integer) Page number. Default: 1}

\item{page_size}{(integer) Results per page: Default: 1000}

\item{protocol}{(character) One of any (default), tabledep or griddap}

\item{cdm_data_type}{(character) One of grid, other, point, profile, timeseries,
timeseriesprofile, trajectory, trajectoryprofile}

\item{institution}{(character) An institution. See the dataset \code{institutions}.}

\item{ioos_category}{(character) An ioos category See the dataset \code{ioos_categories}.}

\item{keywords}{(character) A keywords. See the dataset \code{keywords}.}

\item{long_name}{(character) A long name. See the dataset \code{longnames}.}

\item{standard_name}{(character) A standar dname. See the dataset \code{standardnames}.}

\item{variableName}{(character) A variable name. See the dataset \code{variablenames}.}

\item{maxLat}{(numeric) Maximum latitude}

\item{minLon}{(numeric) Minimum longitude}

\item{maxLon}{(numeric) Maximum longitude}

\item{minLat}{(numeric) Minimum latitude}

\item{minTime}{(numeric) Minimum time}

\item{maxTime}{(numeric) Maximum time}

\item{url}{A URL for an ERDDAP server. Default: \url{http://upwell.pfeg.noaa.gov/erddap/}}

\item{...}{Further args passed on to \code{\link[httr]{GET}} (must be a named parameter)}
}
\description{
Advanced search for ERDDAP tabledep or griddap datasets
}
\examples{
\dontrun{
ed_search_adv(query = 'temperature')
ed_search_adv(query = 'temperature', protocol = "griddap")
ed_search_adv(query = 'temperature', protocol = "tabledap")
ed_search_adv(maxLat = 63, minLon = -107, maxLon = -87, minLat = 50, protocol = "griddap")
ed_search_adv(maxLat = 63, minLon = -107, maxLon = -87, minLat = 50, protocol = "tabledap")
ed_search_adv(minTime = "2010-01-01T00:00:00Z", maxTime="2010-02-01T00:00:00Z")
(out <- ed_search_adv(maxLat = 63, minLon = -107, maxLon = -87, minLat = 50,
             minTime = "2010-01-01T00:00:00Z", maxTime="2010-02-01T00:00:00Z"))
out$alldata[[1]]
ed_search_adv(variableName = 'upwelling')
ed_search_adv(query = 'upwelling', protocol = "tabledap")

# use a different URL
ed_search_adv(query = 'temperature', url = servers()$url[6])
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/index.html}
}

