% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/search.R
\name{ed_search}
\alias{ed_datasets}
\alias{ed_search}
\title{Search for ERDDAP tabledep or griddap datasets}
\usage{
ed_search(query, page = NULL, page_size = NULL, which = "griddap",
  url = eurl(), ...)

ed_datasets(which = "tabledap", url = eurl())
}
\arguments{
\item{query}{(character) Search terms}

\item{page}{(integer) Page number}

\item{page_size}{(integer) Results per page}

\item{which}{(character) One of tabledep or griddap.}

\item{url}{A URL for an ERDDAP server. Default: \url{http://upwell.pfeg.noaa.gov/erddap/}}

\item{...}{Further args passed on to \code{\link[httr]{GET}} (must be a named parameter)}
}
\description{
Search for ERDDAP tabledep or griddap datasets
}
\examples{
\dontrun{
(out <- ed_search(query='temperature'))
out$alldata[[1]]
(out <- ed_search(query='size'))
out$info

# List datasets
head( ed_datasets('table') )
head( ed_datasets('grid') )

# use a different ERDDAP server
## Marine Institute (Ireland)
ed_search("temperature", url = "http://erddap.marine.ie/erddap/")
## Marine Domain Awareness (MDA) (Italy)
ed_search("temperature", url = "https://bluehub.jrc.ec.europa.eu/erddap/")
}
}
\author{
Scott Chamberlain <myrmecocystus@gmail.com>
}
\references{
\url{http://upwell.pfeg.noaa.gov/erddap/index.html}
}

