% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{copySingleFile}
\alias{copySingleFile}
\alias{copyFile}
\title{Copy a file using \code{robocopy} on Windows and \code{rsync} on Linux/macOS}
\usage{
copySingleFile(
  from = NULL,
  to = NULL,
  useRobocopy = TRUE,
  overwrite = TRUE,
  delDestination = FALSE,
  create = TRUE,
  silent = FALSE
)

copyFile(
  from = NULL,
  to = NULL,
  useRobocopy = TRUE,
  overwrite = TRUE,
  delDestination = FALSE,
  create = TRUE,
  silent = FALSE
)
}
\arguments{
\item{from}{The source file.}

\item{to}{The new file.}

\item{useRobocopy}{For Windows, this will use a system call to \code{robocopy}
which appears to be much faster than the internal \code{file.copy} function.
Uses \verb{/MIR} flag. Default \code{TRUE}.}

\item{overwrite}{Passed to \code{file.copy}}

\item{delDestination}{Logical, whether the destination should have any files deleted,
if they don't exist in the source. This is \verb{/purge} for robocopy and --delete for
rsync.}

\item{create}{Passed to \code{checkPath}.}

\item{silent}{Should a progress be printed.}
}
\value{
This function is called for its side effect, i.e., a file is copied \code{from} to \code{to}.
}
\description{
This is replacement for \code{file.copy}, but for one file at a time.
The additional feature is that it will use \code{robocopy} (on Windows) or
\code{rsync} on Linux or Mac, if they exist.
It will default back to \code{file.copy} if none of these exists.
If there is a possibility that the file already exists, then this function
should be very fast as it will do "update only", i.e., nothing.
}
\examples{
tmpDirFrom <- file.path(tempdir(), "example_fileCopy_from")
tmpDirTo <- file.path(tempdir(), "example_fileCopy_to")
tmpFile1 <- tempfile("file1", tmpDirFrom, ".csv")
tmpFile2 <- tempfile("file2", tmpDirFrom, ".csv")
dir.create(tmpDirFrom, recursive = TRUE, showWarnings = FALSE)
f1 <- normalizePath(tmpFile1, mustWork = FALSE)
f2 <- normalizePath(tmpFile2, mustWork = FALSE)
t1 <- normalizePath(file.path(tmpDirTo, basename(tmpFile1)), mustWork = FALSE)
t2 <- normalizePath(file.path(tmpDirTo, basename(tmpFile2)), mustWork = FALSE)

write.csv(data.frame(a = 1:10, b = runif(10), c = letters[1:10]), f1)
write.csv(data.frame(c = 11:20, d = runif(10), e = letters[11:20]), f2)
copyFile(c(f1, f2), c(t1, t2))
file.exists(t1) ## TRUE
file.exists(t2) ## TRUE
identical(read.csv(f1), read.csv(f2)) ## FALSE
identical(read.csv(f1), read.csv(t1)) ## TRUE
identical(read.csv(f2), read.csv(t2)) ## TRUE

unlink(tmpDirFrom, recursive = TRUE)
unlink(tmpDirTo, recursive = TRUE)

}
\author{
Eliot McIntire and Alex Chubaty
}
