% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packages.R
\name{pkgDep}
\alias{pkgDep}
\alias{pkgDep2}
\alias{pkgDepTopoSort}
\title{Determine package dependencies, first looking at local filesystem}
\usage{
pkgDep(
  packages,
  libPath,
  recursive = TRUE,
  depends = TRUE,
  imports = TRUE,
  suggests = FALSE,
  linkingTo = TRUE,
  topoSort = FALSE,
  repos = getOption("repos"),
  refresh = FALSE,
  verbose = getOption("reproducible.verbose")
)

pkgDep2(
  packages,
  recursive = TRUE,
  depends = TRUE,
  imports = TRUE,
  suggests = FALSE,
  linkingTo = TRUE,
  repos = getOption("repos"),
  refresh = FALSE,
  verbose = getOption("reproducible.verbose"),
  sorted = TRUE
)

pkgDepTopoSort(
  pkgs,
  deps,
  reverse = FALSE,
  topoSort = TRUE,
  useAllInSearch = FALSE,
  returnFull = TRUE
)
}
\arguments{
\item{packages}{a character vector of package names.}

\item{libPath}{The library path where all packages should be installed, and looked for to load
(i.e., call \code{library})}

\item{recursive}{Logical. Should dependencies of dependencies be searched, recursively.
NOTE: Dependencies of suggests will not be recursive. Default \code{TRUE}.}

\item{depends}{Logical. Include packages listed in "Depends". Default \code{TRUE}.}

\item{imports}{Logical. Include packages listed in "Imports". Default \code{TRUE}.}

\item{suggests}{Logical. Include packages listed in "Suggests". Default \code{FALSE}.}

\item{linkingTo}{Logical. Include packages listed in "LinkingTo". Default \code{TRUE}.}

\item{topoSort}{Logical. If \code{TRUE}, the default, then
the returned list of packages will be in order with the
least number of dependencies listed in \code{pkgs} at
the top of the list.}

\item{repos}{The remote repository (e.g., a CRAN mirror), passed to either
\code{install.packages}, \code{install_github} or \code{installVersions}.}

\item{refresh}{There is an internal type of caching. If the results are wrong, likely
set \code{refresh = TRUE}.}

\item{verbose}{logical indicating if output should monitor the package
    search cycles.}

\item{sorted}{Logical. If \code{TRUE}, the default, the packages will be sorted in
the returned list from most number of dependencies to least.}

\item{pkgs}{A vector of package names to evaluate their
reverse depends (i.e., the packages that \emph{use} each
of these packages)}

\item{deps}{An optional named list of (reverse) dependencies.
If not supplied, then \code{tools::dependsOnPkgs(..., recursive = TRUE)}
will be used}

\item{reverse}{logical: if \code{FALSE} (default), regular
    dependencies are calculated, otherwise reverse dependencies.}

\item{useAllInSearch}{Logical. If \code{TRUE}, then all non-core
R packages in \code{search()} will be appended to \code{pkgs}
to allow those to also be identified}

\item{returnFull}{Logical. If \code{TRUE}, then the full reverse
dependencies will be returned; if \code{FALSE}, the default,
only the reverse dependencies that are found within the \code{pkgs}
(and \code{search()} if \code{useAllInSearch = TRUE}) will be returned.}
}
\value{
A possibly ordered, named (with packages as names) list where list elements
are either full reverse depends.
}
\description{
This is intended to replace \code{\link[tools]{package_dependencies}} or
\code{pkgDep} in the \pkg{miniCRAN} package, but with modifications for speed.
It will first check local package directories in \code{libPath}, and it if
the function cannot find the packages there, then it will use
\code{\link[tools]{package_dependencies}}.

\code{pkgDep2} is a convenience wrapper of \code{pkgDep} that "goes one level in",
i.e., the first order dependencies, and runs the \code{pkgDep} on those.

This is a wrapper around \code{tools::dependsOnPkgs},
but with the added option of \code{sorted}, which
will sort them such that the packages at the top will have
the least number of dependencies that are in \code{pkgs}.
This is essentially a topological sort, but it is done
heuristically. This can be used to e.g., \code{detach} or
\code{unloadNamespace} packages in order so that they each
of their dependencies are detached or unloaded first.
}
\note{
\code{package_dependencies} and \code{pkgDep} will differ under the following
circumstances:
\enumerate{
  \item GitHub packages are not detected using \code{tools::package_dependencies};
  \item \code{tools::package_dependencies} does not detect the dependencies of base packages
    among themselves, \emph{e.g.}, \code{methods} depends on \code{stats} and \code{graphics}.
}
}
\examples{
pkgDep("crayon")
pkgDep2("reproducible")
}
