% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{downloadFile}
\alias{downloadFile}
\title{A wrapper around a set of downloading functions}
\usage{
downloadFile(archive, targetFile, neededFiles, destinationPath, quick,
  checksumFile, dlFun = NULL, checkSums, url, needChecksums,
  overwrite = TRUE, purge = FALSE, ...)
}
\arguments{
\item{archive}{Optional character string giving the path of an archive
containing \code{targetFile}, or a vector giving a set of nested archives
(e.g., \code{c("xxx.tar", "inner.zip")}). If there is/are (an) inner
archive(s), but they are unknown, the function will try all until it finds
the \code{targetFile}. See table in \code{\link{preProcess}}.}

\item{targetFile}{Character string giving the path to the eventual file
(raster, shapefile, csv, etc.) after downloading and extracting from a zip
or tar archive. This is the file \emph{before} it is passed to
\code{postProcess}. Currently, the internal checksumming does not checksum
the file after it is \code{postProcess}ed (e.g., cropped/reprojected/masked).
Using \code{Cache} around \code{prepInputs} will do a sufficient job in these cases.
See table in \code{\link{preProcess}}.}

\item{neededFiles}{Character string giving the name of the file(s) to be extracted.}

\item{destinationPath}{Character string of a directory in which to download
and save the file that comes from \code{url} and is also where the function
will look for \code{archive} or \code{targetFile}.}

\item{quick}{Logical. This is passed internally to \code{\link{Checksums}}
(the quickCheck argument), and to
\code{\link{Cache}} (the quick argument). This results in faster, though
less robust checking of inputs. See the respective functions.}

\item{checksumFile}{A character string indicating the absolute path to the \code{CHECKSUMS.txt}
file.}

\item{dlFun}{Optional "download function" name, such as \code{"raster::getData"}, which does
custom downloading, in addition to loading into R. Still experimental.}

\item{checkSums}{A checksums file, e.g., created by Checksums(..., write = TRUE)}

\item{url}{Optional character string indicating the URL to download from.
If not specified, then no download will be attempted. If not entry
exists in the \code{CHECKSUMS.txt} (in \code{destinationPath}), an entry
will be created or appended to. This \code{CHECKSUMS.txt} entry will be used
in subsequent calls to
\code{prepInputs} or \code{preProcess}, comparing the file on hand with the ad hoc
\code{CHECKSUMS.txt}. See table in \code{\link{preProcess}}.}

\item{needChecksums}{A numeric, with \code{0} indicating do not write a new checksums,
\code{1} write a new one,
\code{2} append new information to existing one.}

\item{overwrite}{Logical. Should downloading and all the other actions occur
even if they pass the checksums or the files are all there.}

\item{purge}{Logical or Integer. \code{0/FALSE} (default) keeps existing
\code{CHECKSUMS.txt} file and
\code{prepInputs} will write or append to it. \code{1/TRUE} will deleted the entire
\code{CHECKSUMS.txt} file. Other options, see details.}

\item{...}{Passed to \code{dlFun}. Still experimental.}
}
\description{
Currently, this only deals with \code{\link[googledrive]{drive_download}},
and \code{\link[utils]{download.file}}.
}
\author{
Eliot McIntire
}
