% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{RandomExperimentSimulations}
\alias{RandomExperimentSimulations}
\title{RandomExperimentSimulations}
\usage{
RandomExperimentSimulations(
  mean,
  sd,
  diff,
  N,
  reps,
  type = "n",
  seed = 123,
  StdAdj = 0,
  returnData = FALSE
)
}
\arguments{
\item{mean}{The default mean used for both groups (one treatment group and one control group). It can be changed for the treatment group using  the parameter diff}

\item{sd}{This is the default spread for both groups. It must be a real value greater than 0. It can be adjusted for the treatment group using the parameter StdAdj}

\item{diff}{This is added to the treatment group mean. It can be a real value and can take the value zero.}

\item{N}{this is the number of observations in each group. It must be an integer greater than 3.}

\item{reps}{this identifies the number of times each experiment simulation is replicated.}

\item{type}{this specifies the underlying distribution used to generate the data. It takes the values "n" for a normal distribution, "l" for lognormal distribution,"g" for a gamma distribution, "lap" for a Laplace distribution.}

\item{seed}{This specifies the initial seed for the set of replications (default 123).}

\item{StdAdj}{this specifes the extent of variance instability introduced by the treatment and it must be non-negative but can be 0.}

\item{returnData}{If TRUE, the function returns the individual effect sizes and their variances, otherwise it returns summary statistics (default FALSE).}
}
\description{
This function performs multiple simulations of two-group balanced experiments for one of four distributions and a specific group size. It identifies the average value of phat, Cliff' d and Kendall's point biserial tau and their variances. It either returns the effect sizes for each non-parametric effect size or it reports the number of times the each non-parametric effect size is assessed to be significantly different from zero. We also present the values for the t-test as a comparison. For log-normal data the results of analysing the transformed data are also reported.
}
\examples{
#RandomExperimentSimulations(mean=0,sd=1,diff=0.5,N=20, reps=500,type="n",seed=123,StdAdj=0)
#reps=500 may take a bit too for CRAN so let us use reps=50
RandomExperimentSimulations(mean=0,sd=1,diff=0.5,N=20, reps=50,type="n",seed=123,StdAdj=0)
# A tibble: 1 x 17
#   phat phatvar sigphat emp.phat.var     d   dvar  sigd emp.d.var  ktau ktauvar emp.tau.var
# kpowerCVt tpower    ES
#  <dbl>   <dbl>   <dbl>        <dbl> <dbl>  <dbl> <dbl>     <dbl> <dbl>   <dbl>       <dbl>
# <dbl>  <dbl> <dbl>
#1 0.639 0.00793    0.33      0.00790 0.278 0.0324 0.306    0.0316 0.143 0.00854     0.00832
# 0.328  0.338 0.500
# … with 3 more variables: Variance <dbl>, StdES <dbl>, MedDiff <dbl>
#RandomExperimentSimulations(mean=0,sd=1,diff=0.5,N=20, reps=500,type="l",seed=123,StdAdj=0)
#reps=500 may take a bit too for CRAN so let us use reps=50
RandomExperimentSimulations(mean=0,sd=1,diff=0.5,N=20, reps=50,type="l",seed=123,StdAdj=0)
# A tibble: 1 x 20
#   phat phatvar sigphat emp.phat.var     d   dvar  sigd emp.d.var  ktau ktauvar emp.tau.var
# kpowerCVt tpower    ES
#  <dbl>   <dbl>   <dbl>        <dbl> <dbl>  <dbl> <dbl>     <dbl> <dbl>   <dbl>       <dbl>
# <dbl>  <dbl> <dbl>
#1 0.639 0.00793    0.33      0.00790 0.278 0.0324 0.306    0.0316 0.143 0.00854     0.00832
# 0.328  0.218  1.05
# … with 6 more variables: Variance <dbl>, StdES <dbl>, MedDiff <dbl>, ESLog <dbl>,
# StdESLog <dbl>, VarLog <dbl>
RandomExperimentSimulations(mean=0,sd=1,diff=0.5,N=20, reps=10,type="n",seed=123,StdAdj=0,
returnData=TRUE)
#  A tibble: 10 x 3
#    Cliffd  PHat   StdES
#     <dbl> <dbl>   <dbl>
#  1  0.175 0.588  0.340
#  2  0.19  0.595  0.283
#  3 -0.125 0.438 -0.305
#  4  0.195 0.597  0.345
#  5  0.15  0.575  0.200
#  6  0.3   0.65   0.430
#  7  0.455 0.728  0.762
#  8  0.015 0.507  0.0622
#  9  0.16  0.58   0.340
# 10  0.2   0.6    0.336
}
\author{
Barbara Kitchenham and Lech Madeyski
}
