% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr_matrix_df.r
\name{repr_*.matrix/data.frame}
\alias{repr_*.matrix/data.frame}
\alias{repr_html.matrix}
\alias{repr_html.data.frame}
\alias{repr_latex.matrix}
\alias{repr_latex.data.frame}
\alias{repr_markdown.matrix}
\alias{repr_markdown.data.frame}
\alias{repr_text.matrix}
\alias{repr_text.data.frame}
\title{Tabular data representations}
\usage{
\method{repr_html}{matrix}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"))

\method{repr_html}{data.frame}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"))

\method{repr_latex}{matrix}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"),
  colspec = getOption("repr.matrix.latex.colspec"))

\method{repr_latex}{data.frame}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"),
  colspec = getOption("repr.matrix.latex.colspec"))

\method{repr_markdown}{matrix}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"))

\method{repr_markdown}{data.frame}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"))

\method{repr_text}{matrix}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"))

\method{repr_text}{data.frame}(obj, ...,
  rows = getOption("repr.matrix.max.rows"),
  cols = getOption("repr.matrix.max.cols"))
}
\arguments{
\item{obj}{The matrix or data.frame to create a representation for}

\item{...}{ignored}

\item{rows}{The maximum number of rows displayed. The default is given by the option \code{repr.matrix.max.rows}}

\item{cols}{The maximum number of columns displayed. The default is given by the option \code{repr.matrix.max.cols}}

\item{colspec}{The colspec for the LaTeX table. The default is given by the option \code{repr.matrix.latex.colspec}}
}
\description{
HTML, LaTeX, and Markdown representations of Matrix-like objects
}
\seealso{
\link{repr-options} for \code{repr.matrix.latex.colspec}
}
