% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_style.R
\name{create_style}
\alias{create_style}
\title{Creates a style object}
\usage{
create_style(
  font_name = NULL,
  font_size = NULL,
  text_color = NULL,
  background_color = NULL,
  title_font_size = NULL,
  title_font_bold = NULL,
  title_font_color = NULL,
  title_background = NULL,
  footnote_font_bold = NULL,
  footnote_font_color = NULL,
  footnote_background = NULL,
  border_color = NULL,
  table_header_background = NULL,
  table_header_font_bold = NULL,
  table_header_font_color = NULL,
  table_body_background = NULL,
  table_body_stripe = NULL,
  table_body_font_color = NULL,
  table_stub_background = NULL,
  table_stub_font_color = NULL,
  table_stub_font_bold = NULL,
  table_label_row_bold = NULL
)
}
\arguments{
\item{font_name}{The name of the font to use on the report.  Valid values
are "Courier", "Arial", or "Times".  The default is "Courier".}

\item{font_size}{The default font size to use for the report.  This font
size will be used for all text, unless overridden by another font size 
parameter.}

\item{text_color}{The default color to use for all text in the report.  This
parameter will apply to the entire report, unless overridden by other
font color settings.}

\item{background_color}{The color to use for the background of the report.
This color will appear everywhere on the document unless overridden 
by another color specification.}

\item{title_font_size}{The font size to use for the title font in points.}

\item{title_font_bold}{Whether to bold the title or not.  Valid values 
are TRUE or FALSE. By default, the title will not be bold.}

\item{title_font_color}{The color to use for the title font.}

\item{title_background}{The background color for the title block.}

\item{footnote_font_bold}{Whether to bold the footnote or not.  Valid values 
are TRUE or FALSE. By default, the footnote will not be bold.}

\item{footnote_font_color}{The font color to use for footnotes.}

\item{footnote_background}{The color to be used for the background of 
footnotes.}

\item{border_color}{The color to use for all borders in the report.
By default, the border will be black.}

\item{table_header_background}{The background color to use in the table header.
This color may be different than the background color used in the table
body.}

\item{table_header_font_bold}{Whether to bold the header labels or not.
Valid values are TRUE and FALSE. By default, the header will not be bold.}

\item{table_header_font_color}{The font color to use on the table header.}

\item{table_body_background}{The background color to use in the body of any 
table in the report.}

\item{table_body_stripe}{The background color to use for every other row
in a table.  The stripe color is used in conjunction with the body background
color to perform table striping.  The stripe color will start on the second row.}

\item{table_body_font_color}{The font color to use for the body of any 
table in the report.}

\item{table_stub_background}{The background color to use for the stub column,
if one exists on the table.}

\item{table_stub_font_color}{The font color to be used for the stub column,
if one exists on the table.}

\item{table_stub_font_bold}{Whether or not to bold the stub column.  Valid
values are TRUE and FALSE.}

\item{table_label_row_bold}{Whether or not to bold the label row on a stub
column.  This parameter is so you can bold the label row, but not the 
values in the stub column.  Valid values are TRUE and FALSE.}
}
\description{
This function will create a style object to control background colors and 
font settings on your report.  The style object can be applied to a 
report using the \code{\link{add_style}} function. Currently, styles may only
be applied to HTML reports.
}
\details{
The style object contains style settings for a report. The style object 
allows you to control background colors and font specifications such as 
font size, font color, and font bold.  The style object can be created
once and reused on many reports.  See the \code{\link{add_style}} function
to learn how to add the style object to a report.  

Note that styles will be applied uniformly to the entire report.  Also note
that at present, styles can be used only on HTML output types. Future versions
of the \strong{reporter} package will provide style support for other 
output types.

On the style object, colors for background and fonts may be passed as 
an RGB hex code or a color name. For example, the color red may be passed as
the hex code "#FF0000" or as the color name "Red". Color names must conform
to HTML/CSS standards.  These color names can be easily discovered on 
the internet.  A sample of common color names is presented below.
}
\section{Color Names}{

Many of the parameters on the style object accept a color name or code.
The values accepted for these parameters follow standard HTML/CSS style
color values.  Below is a sample of common color names
that can be used to specify colors with the \code{create_style} function.
These color names should be passed as a quoted string:
\itemize{
  \item \strong{Primary and Secondary Colors:} Black, White, Red, Yellow, 
  Blue, Green, Orange, Purple and Brown.
  \item \strong{Common Shades:} Beige, Crimson, Gold, Indigo, Ivory, Lavender, 
  Maroon, Navy, Olive, Pink, 
  Plum, RoyalBlue, Silver, Teal, Turquoise, Violet
  \item \strong{Shades of White:} AntiqueWhite, Azure, GhostWhite, 
  SeaShell, Snow, WhiteSmoke
  \item \strong{Shades of Grey:} Grey, Gray, DarkGray, DarkGrey, DimGray, DimGrey, 
  LightGray, LightGrey, SlateGray, SlateGrey
  \item \strong{Shades of Blue:} AliceBlue, CadetBlue, CornflowerBlue, 
  DodgerBlue, PowderBlue, LightBlue, MidnightBlue, SkyBlue, SlateBlue, SteelBlue
  \item \strong{Earth Colors:} Beige, Bisque, BurlyWood, ForestGreen, Khaki,
   Linen, SandyBrown, SaddleBrown, Salmon, SeaGreen, Sienna, Tan, Thistle, Wheat
  \item \strong{Bright Colors:} Aqua, Aquamarine, BlueViolet, Cyan, Fuchia, 
  HotPink, Lime, Magenta, OrangeRed, SpringGreen
}
}

\examples{
library(reporter)
library(magrittr)

# Prepare data
dat <- data.frame(stub = rownames(mtcars), mtcars)
dat <- dat[1:15, ]

# Create temp file path
tmp <- file.path(tempdir(), "HairAndEyes2.html")

# Define custom style
sty <- create_style(font_name = "Arial",
                    font_size = 10,
                    background_color = "WhiteSmoke",
                    border_color = "Grey",
                    title_font_size = 12,
                    title_font_bold = TRUE,
                    title_font_color = "SteelBlue",
                    table_header_background = "Tan",
                    table_header_font_bold = TRUE,
                    table_header_font_color = "White",
                    table_body_background = "White",
                    table_body_stripe = "Wheat", 
                    table_stub_background = "Tan",
                    table_stub_font_color = "White")

# Create table object
tbl <- create_table(dat, borders = "all") \%>\% 
titles("MTCARS Dataset With Style") \%>\% 
column_defaults(width = .5) \%>\% 
define(stub, label = "Car Make and Model", width = 1.5)

# Create report and add style spec
rpt <- create_report(tmp, output_type = "HTML") \%>\% 
       add_content(tbl) \%>\% 
       add_style(style = sty)

# Write out the report        
write_report(rpt)

# Uncomment to View report
# file.show(tmp)
}
\seealso{
Other styles: 
\code{\link{add_style}()},
\code{\link{get_theme}()},
\code{\link{print.style_spec}()}
}
\concept{styles}
