% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_spec.R
\name{create_plot}
\alias{create_plot}
\title{Create plot content}
\usage{
create_plot(x, height, width, borders = "none")
}
\arguments{
\item{x}{The plot to create.  Specifically, this parameter should be 
set to an object returned from a call to \code{\link[ggplot2]{ggplot}}
or \code{\link[survminer]{ggsurvplot}}.}

\item{height}{The height of the plot in the specified units of measure.}

\item{width}{The width of the plot in the specified units of measure.}

\item{borders}{Whether and where to place a border. Valid values are 'top',
'bottom', 'left', 'right', 'all', 'none', and 'outside'.  
Default is 'none'.  The 'left', 'right', and 'outside' 
border specifications only apply to RTF reports.}
}
\value{
The plot specification.
}
\description{
Function to create a plot specification that can be 
added as content to a report. The \code{create_plot} function can 
be used to include charts, graphs, and figures on a statistical report.  
The function only supports plot objects returned by 
\code{\link[ggplot2]{ggplot}} or \code{\link[survminer]{ggsurvplot}}.  
It does not support the Base R 
\code{plot} function.
}
\details{
To add a plot to a report, use the \code{create_plot} function.  The 
function allows you to set a width and height for the plot.  The
function will preserve any other geometries you apply to the plot.  See
the \code{\link{add_content}} function to control page breaking and 
blanks spaces above or below the plot.    

A plot specification accepts a \code{\link{page_by}} function.  If a page by
is applied to the plot, the plot data will be subset by the page by 
variable, and re-run for each subset.

The plot specification also accepts titles and footnotes.  See the 
\code{\link{titles}} and \code{\link{footnotes}} functions for further 
details.
}
\examples{
library(reporter)
library(ggplot2)
library(magrittr)

# Create temp file path
tmp <- file.path(tempdir(), "mtcars.rtf")

# Create ggplot
p <- ggplot(mtcars, aes(x=cyl, y=mpg)) + geom_point()

# Create plot object
plt <- create_plot(p, height = 4, width = 8)

rpt <- create_report(tmp, output_type = "RTF") \%>\%
  page_header("Client", "Study: XYZ") \%>\% 
  titles("Figure 1.0", "MTCARS Miles per Cylinder Plot") \%>\%
  set_margins(top = 1, bottom = 1) \%>\%
  add_content(plt) \%>\%
  footnotes("* Motor Trend, 1974") \%>\% 
  page_footer("Time", "Confidential", "Page [pg] of [tpg]")

# Write out report
write_report(rpt)

# Uncomment to view RTF file
# shell.exec(tmp)
}
\seealso{
\code{\link{titles}} to add a title block to the plot,  
\code{\link{footnotes}} to add footnotes, and \code{\link{add_content}} 
to add the plot object to a report.

Other plot: 
\code{\link{print.plot_spec}()}
}
\concept{plot}
