% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{plotuv}
\alias{plotuv}
\title{Plot multiple bivariate relationships in a single plot}
\usage{
plotuv(
  response,
  covs,
  data,
  showN = FALSE,
  showPoints = TRUE,
  na.rm = TRUE,
  response_title = NULL,
  return_plotlist = FALSE,
  ncol = 2,
  p_margins = c(0, 0.2, 1, 0.2)
)
}
\arguments{
\item{response}{character vector with names of columns to use for response}

\item{covs}{character vector with names of columns to use for covariates}

\item{data}{dataframe containing your data}

\item{showN}{boolean indicating whether sample sizes should be shown on the
plots}

\item{showPoints}{boolean indicating whether individual data points should be
shown when n>20 in a category}

\item{na.rm}{boolean indicating whether na values should be shown or removed}

\item{response_title}{character value with title of the plot}

\item{return_plotlist}{boolean indicating that the list of plots should be
returned instead of a plot, useful for applying changes to the plot, see
details}

\item{ncol}{the number of columns of plots to be display in the ggarrange
call, defaults to 2}

\item{p_margins}{sets the TRBL margins of the individual plots, defaults to
c(0,0.2,1,.2)}
}
\value{
a list containing plots for each variable in covs

a plot object
}
\description{
This function is designed to accompany \code{\link{uvsum}} as a means of
visualising the results, and uses similar syntax.
}
\details{
Plots are displayed as follows: If response is continuous For a numeric
predictor scatterplot For a categorical predictor: If 20+ observations
available boxplot, otherwise dotplot with median line If response is a factor
For a numeric predictor: If 20+ observations available boxplot, otherwise
dotplot with median line For a categorical predictor barplot Response
variables are shown on the ordinate (y-axis) and covariates on the abscissa
(x-axis)
}
\examples{
## Run multiple univariate analyses on the pembrolizumab dataset to predict cbr and
## then visualise the relationships.
rm_uvsum(data=pembrolizumab,
response='cbr',covs=c('age','sex','l_size','baseline_ctdna'))
plotuv(data=pembrolizumab,  response='cbr',
covs=c('age','sex','l_size','baseline_ctdna'),showN=TRUE)
}
\seealso{
\code{\link{ggplot}} and \code{\link{ggarrange}}
}
\keyword{plot}
