% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_dependencies}
\alias{repo_dependencies}
\title{Build and/or plots a dependency graph}
\usage{
repo_dependencies(tags = NULL, tagfun = "OR", depends = T, attached = T,
  generated = T, plot = T, ...)
}
\arguments{
\item{tags}{Only show nodes matching tags}

\item{tagfun}{Function specifying how to match tags (by default
"OR": match any of \code{tags}).}

\item{depends}{If TRUE, show "depends on" edges.}

\item{attached}{If TRUE, show "attached to" edges.}

\item{generated}{If TRUE, show "generated by" edges.}

\item{plot}{If TRUE (default), plot the dependency graph.}

\item{...}{Other parameters passed to the \code{plot.igraph}
function.}
}
\value{
Adjacency matrix representing the graph, with edges labeled
    1, 2, 3 corresponding to "depends", "attached" and "generated"
    respectively.
}
\description{
Creates a weighted adjacency matrix, in which \code{(i,j) = x}
means that item \code{i} is in relation \code{x} with item
\code{j}. The resulting graph is plotted.
}
\details{
The relation between any two items \code{i} and \code{j} can have
    values 1, 2 or 3, respectively meaning:
\itemize{
  \item{depends on: }{to build item \code{i}, item \code{j} was necessary.}
  \item{attached to: }{item \code{i} is an attachment item and is attached to
        item \code{j}.}
  \item{generated by: }{item \code{i} has been generated by item \code{j}. Item
        \code{j} is usually an attachment containing the source code that
        generated item \code{i}.}
}
}
\examples{
## Repository creation
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)

## Producing some irrelevant data
data1 <- 1:10
data2 <- data1 * 2
data3 <- data1 + data2

## Putting the data in the database, specifying dependencies
rp$put(data1, "item1", "First item",
    "repo_dependencies")
rp$put(data2, "item2", "Item dependent on item1", 
    "repo_dependencies", depends="item1")
rp$put(data3, "item3", "Item dependent on item1 and item2",
    "repo_dependencies", depends=c("item1", "item2"))

## Creating a temporary plot and attaching it
fpath <- file.path(rp$root(), "temp.pdf")
pdf(fpath)
plot(data1)
dev.off()
rp$attach(fpath, "visualization of item1", "plot",
   to="item1")

## Obtaining the dependency matrix
depmat <- rp$dependencies(plot=FALSE)
print(depmat)
## The matrix can be plotted as a graph (requires igraph package)
rp$dependencies()
## The following hides "generated" edges
rp$dependencies(generated=FALSE)

## wiping temporary repo
unlink(rp_path, TRUE)
}
