% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_tags}
\alias{repo_tags}
\title{List all tags}
\usage{
repo_tags(name)
}
\arguments{
\item{name}{The name of a repository item.}
}
\value{
Character vector of unique tags defined in the repo.
}
\description{
Shows list of all unique tags associated with any item in the
repository.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)

## Putting two items with a few tags
rp$put(1, "item1", "Sample item 1",
    c("repo_tags", "tag1"))
rp$put(2, "item2", "Sample item 2",
    c("repo_tags", "tag2"))

## Looking up tags
rp$tags()

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_put
}
