% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_export}
\alias{repo_export}
\title{Export \code{repo} items to RDS file.}
\usage{
repo_export(name, where = ".", tags = NULL, askconfirm = T)
}
\arguments{
\item{name}{Name (or list of names) of the item/s to export.}

\item{where}{Destination directory}

\item{tags}{List of tags: all items tagged with all the tags in the
list will be exported.}

\item{askconfirm}{If T ask confirmation when exporting multiple
items.}
}
\value{
TRUE on success, FALSE otherwise.
}
\description{
Export \code{repo} items to RDS file.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", "export")
rp$export("item1", tempdir()) # creates item1.RDS in a tempdir

## wiping temporary repo
unlink(rp_path, TRUE)
}
