% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_sys}
\alias{repo_sys}
\title{Run system call on an item}
\usage{
repo_sys(rp, name, command)
}
\arguments{
\item{rp}{An object of class repo.}

\item{name}{Name of a repo item. The path to the file that contains
the item will be passed to the system program.}

\item{command}{System command}
}
\value{
Used for side effects.
}
\description{
Runs a system command passing as parameter the file name containing
the object associated with an item.
}
\examples{
## Repository creation
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)

## Creating a PDF file with a figure.
pdffile <- file.path(rp_path, "afigure.pdf")
pdf(pdffile)
plot(runif(30), runif(30))
dev.off()

## Attaching the PDF file to the repo
rp$attach(pdffile, "A plot of random numbers", "repo_sys")
## don't need the original PDF file anymore
file.remove(pdffile)

## Opening the stored PDF with Evince document viewer
\dontrun{
rp$sys("afigure.pdf", "evince")
}

## wiping temporary repo
unlink(rp_path, TRUE)
}

