% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_attach}
\alias{repo_attach}
\title{Create a new item from an existing file.}
\usage{
repo_attach(repo, filepath, description, tags, src = NULL, replace = F,
  to = NULL)
}
\arguments{
\item{repo}{An object of class repo.}

\item{filepath}{The path to the file to be stored in the repo.}

\item{description}{A character description of the item.}

\item{tags}{A list of tags to sort the item. Tags are useful for
selecting sets of items and run bulk actions.}

\item{src}{The item's provenance as a list of character. Usually
the name of the script producing the stored object, a website where
the object was downloaded, and so on. If one of the provenance
strings matches the name of a repo's item, this will create a
dependency link.}

\item{replace}{If the item exists, overwrite the specified fields.}

\item{to}{An existing item name to attach the file to.}
}
\value{
Used for side effects.
}
\description{
Create a new item from an existing file.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)

\dontrun{
## Creating a PDF file with a figure.
pdf("afigure.pdf")
## Drawing a random plot in the figure
plot(runif(100), runif(100))
dev.off()
## Attaching the PDF file to the repo
repo$attach("afigure.pdf", "A plot of random numbers", "repo_sys", replace=TRUE)
## don't need the PDF file anymore
file.remove("afigure.pdf")
## Opening the stored PDF with Evince document viewer
repo$sys("afigure.pdf", "evince")
}

## wiping temporary repo
unlink(repo_path, TRUE)
}

