% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps.R
\name{package_deps}
\alias{package_deps}
\alias{local_package_deps}
\alias{dev_package_deps}
\alias{update.package_deps}
\title{Find all dependencies of a CRAN or dev package.}
\usage{
package_deps(packages, dependencies = NA, repos = getOption("repos"),
  type = getOption("pkgType"))

local_package_deps(pkgdir = ".", dependencies = NA)

dev_package_deps(pkgdir = ".", dependencies = NA,
  repos = getOption("repos"), type = getOption("pkgType"))

\method{update}{package_deps}(object, ..., quiet = FALSE, upgrade = TRUE)
}
\arguments{
\item{packages}{A character vector of package names.}

\item{dependencies}{Which dependencies do you want to check?
  Can be a character vector (selecting from "Depends", "Imports",
   "LinkingTo", "Suggests", or "Enhances"), or a logical vector.

  \code{TRUE} is shorthand for "Depends", "Imports", "LinkingTo" and
  "Suggests". \code{NA} is shorthand for "Depends", "Imports" and "LinkingTo"
  and is the default. \code{FALSE} is shorthand for no dependencies (i.e.
  just check this package, not its dependencies).}

\item{repos}{A character vector giving repositories to use.}

\item{type}{Type of package to \code{update}.  If "both", will switch
automatically to "binary" to avoid interactive prompts during package
installation.}

\item{pkgdir}{path to a package directory, or to a package tarball.}

\item{object}{A \code{package_deps} object.}

\item{...}{Additional arguments passed to \code{install_packages}.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{upgrade}{If \code{TRUE}, also upgrade any of out date dependencies.}
}
\value{
A \code{data.frame} with columns:

\tabular{ll}{
\code{package} \tab The dependent package's name,\cr
\code{installed} \tab The currently installed version,\cr
\code{available} \tab The version available on CRAN,\cr
\code{diff} \tab An integer denoting whether the locally installed version
  of the package is newer (1), the same (0) or older (-1) than the version
  currently available on CRAN.\cr
}
}
\description{
Find all the dependencies of a package and determine whether they are ahead
or behind CRAN. A \code{print()} method identifies mismatches (if any)
between local and CRAN versions of each dependent package; an
\code{update()} method installs outdated or missing packages from CRAN.

\code{local_package_deps} extracts dependencies from a
local DESCRIPTION file.

\code{dev_package_deps} lists the status of the dependencies
of a local package.
}
\examples{
\dontrun{
package_deps("devtools")
# Use update to update any out-of-date dependencies
update(package_deps("devtools"))
}
}
