% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-git.R
\name{install_git}
\alias{install_git}
\title{Install a package from a git repository}
\usage{
install_git(url, subdir = NULL, branch = NULL, git = c("auto", "git2r",
  "external"), ...)
}
\arguments{
\item{url}{Location of package. The url should point to a public or
private repository.}

\item{subdir}{A sub-directory within a git repository that may
contain the package we are interested in installing.}

\item{branch}{Name of branch or tag to use, if not master.}

\item{git}{Whether to use the \code{git2r} package, or an external
git client via system. Default is \code{git2r} if it is installed,
otherwise an external git installation.}

\item{...}{passed on to \code{install.packages}}
}
\description{
It is vectorised so you can install multiple packages with
a single command. You do not need to have the \code{git2r} package,
or an external git client installed.
}
\examples{
\dontrun{
install_git("git://github.com/hadley/stringr.git")
install_git("git://github.com/hadley/stringr.git", branch = "stringr-0.2")
}
}
