% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commparms.R
\name{commParams}
\alias{commParams}
\title{Common Parameters used by functions of \code{remiod}}
\arguments{
\item{object}{object inheriting from class 'remoid'}

\item{trtvar}{the name of treatment variable. When necessary, its reference category,
i.e. control arm, can be set in \code{refcats} argument.}

\item{method}{a method for obtaining multiple-imputed dataset. Options include
\code{MAR}, \code{J2R}, \code{CR}, and \code{delta} adjustment.
Default is MAR.}

\item{delta}{specific value used for Delta adjustment, applicable only
for method="delta".}

\item{algorithm}{either algorithm \code{tang_seq} proposed by Tang (2018) or
\code{jags} the original method inherited in JAGS (Plummer 2003).}

\item{model_order}{optional. manually specify an order for imputation models.}

\item{ord_cov_dummy}{optional. specify whether ordinal variables should be treated as
categorical variables or continuous variables when they are
included as covariates in the sequential imputation models.
Default is \code{TRUE}, dummy variables will be created accordingly.}

\item{rinv}{a small number used to adjusting Fish information matrix}

\item{scheme}{scheme of distribution used for proposing coefficients of imputation models.
scheme=1: beta ~ N( mean + inv(I)*score, inv(I));
scheme=2: beta ~ N( mean , inv(I)).}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC
sample). Follows the same principle as the argument
\code{monitor_params} and \code{selected_parms}.}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{progress.bar}{character string specifying the type of
progress bar. Possible values are "text" (default), "gui",
and "none" (see \code{\link[rjags]{update}}). Note: when
sampling is performed in parallel it is not possible to
display a progress bar.}

\item{seed}{optional; seed value (for reproducibility)}

\item{include}{logical, if TRUE, raw data will be included in imputed data sets
with imputation ID = 0.}

\item{mi.setting}{a list of arguments related to multiple imputation, including
trtvar, algorithm, method, include, exclude_chains, thin, start,
end, and seed.}
}
\description{
Common Parameters used by functions of \code{remiod}
}
\keyword{internal}
