#' Reinforcement Learning.
#'
#' Implementations of reinforcement learning algorithms and environments.
#'
#' @md
#'
#' @section Environments:
#' * [makeEnvironment]
#' * [Environment]
#' * [GymEnvironment]
#' * [MdpEnvironment]
#' * [Gridworld]
#' * [WindyGridworld]
#' * [CliffWalking]
#' * [MountainCar]
#' * [MountainCarContinuous]
#'
#' @section Policies:
#' * [makePolicy]
#' * [EpsilonGreedyPolicy]
#' * [GreedyPolicy]
#' * [SoftmaxPolicy]
#' * [RandomPolicy]
#'
#' @section Value Function Representations:
#' * [makeValueFunction]
#' * [ValueTable]
#' * [ValueNetwork]
#'
#' @section Algorithms:
#' * [makeAlgorithm]
#' * [QLearning]
#'
#' @section Extensions:
#' * [makeReplayMemory]
#' * [Eligibility]
#'
#' @section Agent:
#' * [makeAgent]
#' * [getValueFunction]
#' * [getReplayMemory]
#' * [getEligibilityTraces]
#'
#' @section Interaction:
#' * [interact]
#'
#' @name reinforcelearn
#' @aliases reinforcementlearning
#' @docType package
NULL
