rsbplot <- function(data,plot.pval = TRUE,ylim.scan = 2,pch = 16,cex = 0.5,cex.lab = 1.25,main = NA,cex.main = 1.5,cex.axis=1) {
	if (!(grepl("Rsb",colnames(data)[3]))) {stop("Unrecognized column name for Rsb: the data is not a matrix generated by the ies2rsb() function...")} 
	if (colnames(data)[4] == "-log10(p-value) [bilateral]") {
		yleg = expression("-"*log[10]*"[1"~"-"~"2"~"|"~Phi[scriptstyle(italic(Rsb))]~"-"~0.5*"|]")
	}
	else if (colnames(data)[4] == "-log10(p-value) [unilateral]") {
		yleg = expression("-"*log[10]*"[1"~"-"~Phi[scriptstyle(italic(Rsb))]*"|]")
	}
	else {
		warning("Unrecognized column name for p-values: plot.pval has been turned off")
		plot.pval = FALSE
	}
	lst_chrm <- unique(data$CHR)
	nbr_chrm <- length(lst_chrm)
	cum <- rep(0,(nbr_chrm + 1))
	if (nbr_chrm > 1) {
		for (i in 1:nbr_chrm) {
			cum[i + 1] <- tail(data$POSITION[data$CHR == lst_chrm[i]],n = 1)
		}
	}
	cum <- cumsum(cum)
	pos <- rep(0,length(data$CHR))
	pos_labels <- rep(0,nbr_chrm)
	for (i in 1:nbr_chrm) {
		pos[data$CHR == lst_chrm[i]] <- data$POSITION[data$CHR == lst_chrm[i]] + cum[which(lst_chrm == lst_chrm[i])]
		pos_labels[i] <- (cum[i] + cum[i + 1]) / 2
	}
	col_chr <- data$CHR
	if (nbr_chrm > 1) {
	    if (!is.null(names(dev.list())) && ((names(dev.cur()) == "windows") | (names(dev.cur()) == "X11") | (names(dev.cur()) == "quartz"))) {
   	    		dev.new()
    	}
		par(mar = c(5,5,4,2) + 0.1)
		plot(pos,data[,3],pch = pch,cex = cex,las = 1,col = col_chr,xaxt = "n",xlab = "Chromosome",ylab = expression(italic(Rsb)),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
		axis(1,at = pos_labels,labels = lst_chrm,las = 1,cex.lab=cex.lab,cex.axis=cex.axis)
		abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		if (plot.pval) {
		    if (!is.null(names(dev.list())) && ((names(dev.cur()) == "windows") | (names(dev.cur()) == "X11") | (names(dev.cur()) == "quartz"))) {
   	    			dev.new()
    		}
			par(mar = c(5,5,4,2) + 0.1)
			plot(pos,data[,4],pch = pch,cex = cex,las = 1,col = col_chr,xaxt = "n",xlab = "Chromosome",ylab = expression(-log[10]~"("*italic(p)*"-value)"),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
			axis(1,at = pos_labels,labels = lst_chrm,las = 1,cex.lab=cex.lab,cex.axis=cex.axis)
			abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		}
	}
	else {
		if (max(pos) < 1e3) {
			scale <- 1
			unit = "(bp)"
		}
		else if (max(pos) < 1e6) {
			scale <- 1e3
			unit = "(kb)"
		}
		else if (max(pos) < 1e9) {
			scale <- 1e6
			unit = "(Mb)"
		}
		else {
			scale <- 1e9
			unit = "(Gb)"
		}
	    if (!is.null(names(dev.list())) && ((names(dev.cur()) == "windows") | (names(dev.cur()) == "X11") | (names(dev.cur()) == "quartz"))) {
   	    		dev.new()
    	}
		par(mar = c(5,5,4,2) + 0.1)
		plot(pos / scale,data[,3],pch = pch,col = col_chr,xlab = paste("Position",unit),ylab = expression(italic(Rsb)),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
		abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		if (plot.pval) {
		    if (!is.null(names(dev.list())) && ((names(dev.cur()) == "windows") | (names(dev.cur()) == "X11") | (names(dev.cur()) == "quartz"))) {
   		    		dev.new()
    		}
			par(mar = c(5,5,4,2) + 0.1)
			plot(pos / scale,data[,4],pch = pch,col = col_chr,xlab = paste("Position",unit),ylab = expression(-log[10]~"("*italic(p)*"-value)"),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
			abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		}
	}
	par(mar = c(5,4,4,2) + 0.1)	
}
