ihsplot <- function(ihsdata,plot.pval = TRUE,ylim.scan = 2,pch = 16,cex = 0.5,cex.lab = 1.25,main = NA,cex.main = 1.5,cex.axis=1.) {
	if(is.null(ihsdata$iHS) | is.null(ihsdata$frequency.class)){stop("The ihsdata list is invalid and was not generated by the ihh2ihs() function...")}
	data=ihsdata$iHS
#	if (colnames(data)[3] != "iHS") {stop("Unrecognized column name for iHS: the data is not a data frame generated by the ihh2ihs() function...")} 
 	lst_chrm <- unique(data$CHR)
	nbr_chrm <- length(lst_chrm)
	cum <- rep(0,(nbr_chrm + 1))
	if (nbr_chrm > 1) {
		for (i in 1:nbr_chrm) {
			cum[i + 1] <- tail(data$POSITION[data$CHR == lst_chrm[i]],n = 1)
		}
	}
	cum <- cumsum(cum)
	pos <- rep(0,length(data$CHR))
	pos_labels <- rep(0,nbr_chrm)
	for (i in 1:nbr_chrm) {
		pos[data$CHR == lst_chrm[i]] <- data$POSITION[data$CHR == lst_chrm[i]] + cum[which(lst_chrm == lst_chrm[i])]
		pos_labels[i] <- (cum[i] + cum[i + 1]) / 2
	}
	col_chr <- data$CHR
	if (nbr_chrm > 1) {
		dev.new()
		plot.new()
		par(mar = c(5,5,4,2) + 0.1)
		plot(pos,data$iHS,pch = pch,cex = cex,las = 1,col = col_chr,xaxt = "n",xlab = "Chromosome",ylab = expression(italic(iHS)),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
		axis(1,at = pos_labels,labels = lst_chrm,las = 1,cex.lab=cex.lab,cex.axis=cex.axis)
		abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		if (plot.pval) {
			dev.new()
			plot.new()
			par(mar = c(5,5,4,2) + 0.1)
			plot(pos,data$"-log10(p-value)",pch = pch,cex = cex,las = 1,col = col_chr,xaxt = "n",xlab = "Chromosome",ylab = expression("-"*log[10]*"[1"~"-"~"2"~"|"~Phi[scriptstyle(italic(iHS))]~"-"~0.5*"|]"),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
			axis(1,at = pos_labels,labels = lst_chrm,las = 1,cex.lab=cex.lab,cex.axis=cex.axis)
			abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		}
	}
	else {
		if (max(pos) < 1e3) {
			scale <- 1
			unit = "(bp)"
		}
		else if (max(pos) < 1e6) {
			scale <- 1e3
			unit = "(kb)"
		}
		else if (max(pos) < 1e9) {
			scale <- 1e6
			unit = "(Mb)"
		}
		else {
			scale <- 1e9
			unit = "(Gb)"
		}
		dev.new()
		plot.new()
		par(mar = c(5,5,4,2) + 0.1)
		plot(pos / scale,data$iHS,pch = pch,col = col_chr,xlab = paste("Position",unit),ylab = expression(italic(iHS)),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
		abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		if (plot.pval) {
			dev.new()
			plot.new()
			par(mar = c(5,5,4,2) + 0.1)
			plot(pos / scale,data$"-log10(p-value)",pch = pch,col = col_chr,xlab = paste("Position",unit),ylab = expression("-"*log[10]*"[1"~"-"~"2"~"|"~Phi[scriptstyle(italic(iHS))]~"-"~0.5*"|]"),cex.lab = cex.lab,main = main,cex.main = cex.main,cex.axis=cex.axis)
			abline(h = c(-ylim.scan,ylim.scan),lty = 2)
		}
	}
	par(mar = c(5,4,4,2) + 0.1)	
}
