% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{empirical_link}
\alias{empirical_link}
\title{Empirically estimate response values on the link scale}
\usage{
empirical_link(response, family, na.rm = FALSE)
}
\arguments{
\item{response}{Vector of response variable values.}

\item{family}{Family object representing the response distribution and link
function. Only the link function will be used.}

\item{na.rm}{Should \code{NA} values of the response be stripped? Passed to
\code{mean()} when calculating the mean of the response.}
}
\value{
Mean response value, on the link scale.
}
\description{
Calculates the average value of the response variable, and places this on the
link scale. Plotting these against a predictor (by dividing the dataset into
bins) can help assess the choice of link function.
}
\examples{
suppressMessages(library(dplyr))
suppressMessages(library(ggplot2))

mtcars |>
  bin_by_interval(disp, breaks = 5) |>
  summarize(
    mean_disp = mean(disp),
    link = empirical_link(am, binomial())
  ) |>
  ggplot(aes(x = mean_disp, y = link)) +
  geom_point()
}
