% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ElasticLogistic.R
\name{CV.ElasLogistic}
\alias{CV.ElasLogistic}
\title{k-folds cross-validation for Elastic-Net logistic regression.}
\usage{
CV.ElasLogistic(X, Y, lambda = NULL, alpha = 0.5, alpha.i = 1,
  folds = 5, verbo = FALSE)
}
\arguments{
\item{X}{a matrix of predictors.}

\item{Y}{a vector of the binary response.}

\item{lambda}{a user-supplied sequence of lambda values, which serves as a tuning parameter to impose sparsity.
If it is left as NULL, a default sequence will be used.}

\item{alpha}{the Elastic-Net mixing parameter, with \eqn{0 \le \alpha \le 1}. alpha=1 corresponds to the lasso penalty,
and alpha=0 corresponds to the ridge penalty.}

\item{alpha.i}{by default, the program uses the lasso penalty for choosing initial values of
the coefficient vector. alpha.i is the Elastic-Net mixing parameter, with \eqn{0 \le alpha.i \le 1}. alpha.i=1 is the
lasso penalty, and alpha.i=0 the ridge penalty. If alpha.i is assigned to be -1, the program will use zeroes
as initial coefficients.}

\item{folds}{the number of folds for cross-validation.}

\item{verbo}{output progress to the console.}
}
\value{
a list with components:
\item{lambda}{the optimal lambda.}
\item{mcr}{the misclassification rate of the optimal lambda.}
\item{MCR}{a matrix of the misclassification rates for all the values of lambda tested.}
}
\description{
This function does k-fold cross-validation for the Elastic-Net logistic regression and returns
the optimal value of lambda.
}
\references{
Zou H, Hastie T. (2005). Regularization and variable selection via the elastic net.
J.R. Statist.Soc.B, 67(2):301–20.
}
\seealso{
\code{\link{ElasLogistic}}
}
