% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_isolation.R
\name{reg_isolation}
\alias{reg_isolation}
\title{Isolation}
\usage{
reg_isolation(
  region,
  raster,
  dist_fun = "euclidean",
  sample_size = 1,
  unit = "log2"
)
}
\arguments{
\item{region}{An object of class \code{sf} with a \code{POLYGON} or \code{MULTIPOLYGON} geometry type}

\item{raster}{An object of class SpatRaster (terra)}

\item{dist_fun}{Distance measure used. This function uses the \code{philentropy::distance} function in the background. Run \code{philentropy::getDistMethods()} to find possible distance measures.}

\item{sample_size}{Proportion of the cells inside of each region to be used in calculations. Value between 0 and 1.
It is also possible to specify an integer larger than 1, in which case the specified number of cells
of each region will be used in calculations.}

\item{unit}{a character string specifying the logarithm unit that should be used to
compute distances that depend on log computations.}
}
\value{
A vector with the isolation values
}
\description{
Isolation is an average distance between the focus region
and all of its neighbors. This value is between 0 and 1,
where large value indicates that values of the region
stands out from its surroundings.
}
\examples{
\dontrun{
 library(terra)
 library(sf)
 volcano = rast(system.file("raster/volcano.tif", package = "supercells"))
 vr = read_sf(system.file("regions/volcano_regions.gpkg", package = "regional"))
 vr$iso = reg_isolation(vr, volcano, sample_size = 1)

 mean(volcano$iso)

 plot(volcano)
 plot(vect(vr), add = TRUE)
 plot(volcano)
 plot(vr["iso"], add = TRUE)
}
}
