% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ICC.R
\name{ICC}
\alias{ICC}
\alias{ICC.lme}
\alias{ICC.merMod}
\title{Intra-class correlation.}
\usage{
ICC(model, ...)

\method{ICC}{lme}(model, ...)

\method{ICC}{merMod}(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lme' (nlme) or 'merMod' (lme4;
linear, generalized, or nonlinear).}

\item{...}{Not currently implemented; used to ensure consistency with S3 generic.}
}
\value{
The intra-class correlation of the model.
}
\description{
\code{ICC} calculates the intra-class correlation (ICC) from a fitted
hierarchical linear model using the 'nlme' or 'lme4' packages.
}
\details{
The ICC is the proportion of variance that is between-person variance. For
more information, see
\href{http://davidakenny.net/papers/k&h/MLM_R.pdf}{Hoyt & Kenny (2013)}.
}
\section{Methods (by class)}{
\itemize{
\item \code{lme}: Intra-class correlation for lme (nlme).

\item \code{merMod}: Intra-class correlation for lmer (lme4).
}}

\examples{
# iris data, showing use with lme()
if (require(nlme, quietly=TRUE)) {
    model <- lme(Sepal.Width ~ 1, random=~1|Species, data=iris)
    ICC(model)  # .49 of variance is between-subjects
}

# iris data, showing use with lmer()
if (require(lme4, quietly=TRUE)) {
    model <- lmer(Sepal.Width ~ 1 + (1|Species), data=iris)
    ICC(model)  # .49 of variance is between-subjects
}
}
