% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regDF.R
\name{regDF}
\alias{regDF}
\alias{regDF.default}
\alias{regDF.formula}
\title{Dynamic Filter for Regression}
\usage{
\method{regDF}{default}(x, y, t = 0.2, nfolds = 10, m = 3, vote = FALSE, ...)

\method{regDF}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a double vector with the output regressand of each sample.}

\item{t}{a double in [0,1] with the \emph{threshold} used by regression noise filter (default: 0.2).}

\item{nfolds}{number of folds in which the dataset is split (default: 10).}

\item{m}{an integer in [1,9] with the number of algorithms in the ensemble (default: 3).}

\item{vote}{a logical indicating if the consensus voting (\code{TRUE}) or majority voting (\code{FALSE}) is used (default: \code{FALSE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output regressand and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
The result of applying the regression filter is a reduced dataset containing the clean samples (without errors or noise), since it removes noisy samples (those with errors).
This function returns an object of class \code{rfdata}, which contains information related to the noise filtering process in the form of a list with the following elements:
\item{xclean}{a data frame with the input attributes of clean samples (without errors).}
\item{yclean}{a double vector with the output regressand of clean samples (without errors).}
\item{numclean}{an integer vector with the amount of clean samples.}
\item{idclean}{an integer vector with the indices of clean samples.}
\item{xnoise}{a data frame with the input attributes of noisy samples (with errors).}
\item{ynoise}{a double vector with the output regressand of noisy samples (with errors).}
\item{numnoise}{an integer vector with the amount of noisy samples.}
\item{idnoise}{an integer vector with the indices of noisy samples.}
\item{filter}{the full name of the noise filter used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}

Note that objects of the class \code{rfdata} support \link{print.rfdata} and \link{summary.rfdata} methods.
}
\description{
Application of the regDF noise filtering method in a regression dataset.
}
\details{
In classification, \emph{Dynamic Filter} (DF) divides the dataset into \code{nfolds} cross-validation folds and obtains the prediction of
9 classifiers: SVM; k-NN with \code{k} = 3, 5 and 9; CART; C4.5; MLPN;
\emph{Random Forest} and \emph{Naive Bayes}. Then, it selects one ensemble of size \code{m} with best predictions.
Finally, a sample is considered as noisy using a voting scheme (indicated by the argument \code{vote}): if equal to \code{TRUE},
a consensus voting is used (in which a sample is removed if it is misclassified by all the models); if equal to \code{FALSE},
a majority voting is used (in which a sample is removed if it is misclassified by more than a half of the models).
The implementation of this noise filter to be used in regression problems follows the proposal of Martín \emph{et al.} (2021),
which is based on the use of a noise threshold (\code{t}) to determine the similarity between the output variable of the samples.
}
\examples{
# load the dataset
data(rock)

# usage of the default method
set.seed(9)
out.def <- regDF(x = rock[,-ncol(rock)], y = rock[,ncol(rock)])

# show results
summary(out.def, showid = TRUE)

# usage of the method for class formula
set.seed(9)
out.frm <- regDF(formula = perm ~ ., data = rock)

# check the match of noisy indices
all(out.def$idnoise == out.frm$idnoise)

}
\references{
L. Garcia, A. Lorena and A. Carvalho,
\strong{A study on class noise detection and elimination},
\emph{Brazilian Symposium on Neural Networks}, 13-18, 2012.
\doi{https://doi.org/10.1109/SBRN.2012.49}.

J. Martín, J. A. Sáez and E. Corchado,
\strong{On the regressand noise problem: Model robustness and synergy with regression-adapted noise filters.}
\emph{IEEE Access}, 9:145800-145816, 2021.
\doi{https://doi.org/10.1109/ACCESS.2021.3123151}.
}
\seealso{
\code{\link{regEF}}, \code{\link{regGE}}, \code{\link{regHRRF}}, \code{\link{print.rfdata}}, \code{\link{summary.rfdata}}
}
