% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refseq_XPfromXM.R
\name{refseq_XPfromXM}
\alias{refseq_XPfromXM}
\title{Get the XP accession from XM accession}
\usage{
refseq_XPfromXM(xm)
}
\arguments{
\item{xm}{A character string of the XP id.}
}
\value{
A character vector containing the XP id encoded by the XM especified as \code{xm}.
}
\description{
\code{refseq_XPfromXM()} Returns the XP accession from a single XM accession.
}
\examples{
 # Get the XP id from a single XM accession
 xm <- "XM_004487701"
 refseq_XPfromXM(xm)

 \donttest{
 # Get the XP ids from a set of XM accessions
 xm = c("XM_004487701", "XM_004488493")
 sapply(xm, function(x) refseq_XPfromXM(x), USE.NAMES = FALSE) }

}
\seealso{
\code{\link{refseq_XMfromXP}} to obtain the XM ids that encode a set of XP ids.
}
\author{
Jose V. Die
}
