% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splits.R
\name{splits_count}
\alias{splits_count}
\title{Count the Number of Splits in Each Administrative Unit}
\usage{
splits_count(plans, shp, admin)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object, tibble, or data frame containing other columns}

\item{admin}{unqouted name of column in shp with numeric identifiers for administrative units}
}
\value{
numeric matrix
}
\description{
Tallies the number of unique administrative unit-districts. An unsplit administrative
unit will return an entry of 1, while each additional administrative unit-district
adds 1.
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
splits_count(plans = nh$r_2020, shp = nh, admin = county)

# Or many plans:
splits_count(plans = nh_m[, 3:5], shp = nh, admin = county)

}
\concept{splits}
