% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_shortburst.R
\name{redist_shortburst}
\alias{redist_shortburst}
\title{Redistricting Optimization through Short Bursts}
\usage{
redist_shortburst(
  map,
  score_fn = NULL,
  stop_at = NULL,
  burst_size = ifelse(backend == "mergesplit", 10L, 50L),
  max_bursts = 500L,
  maximize = TRUE,
  init_plan = NULL,
  counties = NULL,
  compactness = 1,
  adapt_k_thresh = 0.975,
  return_all = TRUE,
  backend = "mergesplit",
  flip_lambda = 0,
  flip_eprob = 0.05,
  flip_constraints = list(),
  verbose = TRUE
)
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{score_fn}{A function which takes a matrix of plans and returns a score
for each plan. Can also be a purrr-style anonymous function. See
\code{\link[=scorers]{?scorers}} for some function factories for common scoring rules.}

\item{stop_at}{A threshold to stop optimization at.}

\item{burst_size}{The size of each burst. 10 is recommended for mergesplit and 50 for flip.}

\item{max_bursts}{The maximum number of bursts to run before returning.}

\item{maximize}{If \code{TRUE}, try to maximize the score; otherwise, try to
minimize it.}

\item{init_plan}{The initial state of the map. If not provided, will default to
the reference map of the \code{map} object, or if none exists, will sample
a random initial state using \code{\link{redist_smc}}. You can also request
a random initial state by setting \code{init_plan="sample"}.}

\item{counties}{A vector containing county (or other administrative or
geographic unit) labels for each unit, which may be integers ranging from 1
to the number of counties, or a factor or character vector.  If provided, the
algorithm will only generate maps which split up to \code{ndists-1} counties.
If no county-split constraint is desired, this parameter should be left blank.}

\item{compactness}{Controls the compactness of the generated districts, with
higher values preferring more compact districts. Must be non-negative. See
\code{\link{redist_mergesplit}} for more information.}

\item{adapt_k_thresh}{The threshold value used in the heuristic to select a
value \code{k_i} for each splitting iteration. Set to 0.9999 or 1 if
the algorithm does not appear to be sampling from the target distribution.
Must be between 0 and 1.}

\item{return_all}{Whether to return all the
Recommended for monitoring purposes.}

\item{backend}{the MCMC algorithm to use within each burst, either
"mergesplit" or "flip".}

\item{flip_lambda}{The parameter determining the number of swaps to attempt each iteration of flip mcmc.
The number of swaps each iteration is equal to Pois(lambda) + 1. The default is 0.}

\item{flip_eprob}{The probability of keeping an edge connected in flip mcmc. The default is 0.05.}

\item{flip_constraints}{A list of constraints to use for flip mcmc. Can be created with
\code{flip_constraints_helper}. Defaults to an edges-removed compactness constraint with weight 0.6.}

\item{verbose}{Whether to print out intermediate information while sampling.
Recommended for monitoring purposes.}
}
\value{
a \code{redist_plans} object containing the final best plan
(or the best plans after each burst, if \code{return_all=TRUE}.
}
\description{
This function uses \code{\link[=redist_mergesplit]{redist_mergesplit()}} to optimize a redistrict plan
according to a user-provided criteria. It does so by running the Markov chain
for "short bursts" of usually 10 iterations, and then starting the chain anew
from the best plan in the burst, according to the criteria. This implements
the ideas in the below-referenced paper, "Voting Rights, Markov Chains, and
Optimization by Short Bursts."
}
\examples{
\donttest{
data(iowa)

iowa_map = redist_map(iowa, existing_plan=cd_2010, pop_tol=0.01)
redist_shortburst(iowa_map, scorer_frac_kept(iowa_map), max_bursts=50)
redist_shortburst(iowa_map, ~ 1 - scorer_frac_kept(iowa_map)(.), max_bursts=50)
}

}
\references{
Cannon, S., Goldbloom-Helzner, A., Gupta, V., Matthews, J. N., & Suwal, B.
(2020). Voting Rights, Markov Chains, and Optimization by Short Bursts. arXiv
preprint arXiv:2011.02288.
}
\concept{simulate}
