% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_findparams.R
\name{redist.findparams}
\alias{redist.findparams}
\title{Run parameter testing for \code{redist.mcmc}}
\usage{
redist.findparams(adjobj, popvec, nsims, ndists = NULL, initcds = NULL,
adapt_lambda = FALSE, adapt_eprob = FALSE,
params, ssdmat = NULL, grouppopvec = NULL, countymembership = NULL,
nstartval_store, maxdist_startval,
maxiterrsg = 5000, report_all = TRUE,
parallel = FALSE, nthreads = NULL, log = FALSE, verbose = TRUE)
}
\arguments{
\item{adjobj}{An adjacency matrix, list, or object of class
"SpatialPolygonsDataFrame."}

\item{popvec}{A vector containing the populations of each
geographic unit.}

\item{nsims}{The number of simulations run before a save point.}

\item{ndists}{The number of congressional districts.
The default is \code{NULL}.}

\item{initcds}{A vector containing the congressional district labels
of each geographic unit. The default is \code{NULL}. If not provided, random
and contiguous congressional district assignments will be generated using \code{redist.rsg}.}

\item{adapt_lambda}{Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{params}{A matrix of parameter values to test, such as the output of
\code{expand.grid}. Parameters accepted for \code{params} include \code{eprob},
\code{lambda}, \code{popcons}, \code{beta}, and \code{constraint}.}

\item{ssdmat}{A matrix of squared distances between geographic
units. The default is \code{NULL}.}

\item{grouppopvec}{A vector of populations for some sub-group of
interest. The default is \code{NULL}.}

\item{countymembership}{A vector of county membership assignments. The default is \code{NULL}.}

\item{nstartval_store}{The number of maps to sample from the preprocessing chain
for use as starting values in future simulations. Default is 1.}

\item{maxdist_startval}{The maximum distance from the starting map that
sampled maps should be. Default is 100 (no restriction).}

\item{maxiterrsg}{Maximum number of iterations for random seed-and-grow
algorithm to generate starting values. Default is 5000.}

\item{report_all}{Whether to report all summary statistics for each set of
parameter values. Default is \code{TRUE}.}

\item{parallel}{Whether to run separate parameter settings in parallel.
Default is \code{FALSE}.}

\item{nthreads}{Number of parallel tasks to run, declared outside of the
function. Default is \code{NULL}.}

\item{log}{Whether to open a log to track progress for each parameter combination
being tested. Default is FALSE.}

\item{verbose}{Whether to print additional information about the tests.
Default is \code{TRUE}.}
}
\value{
\code{redist.findparams} returns a print-out of summary statistics
about each parameter setting.
}
\description{
\code{redist.findparams} is used to find optimal parameter values of
\code{redist.mcmc} for a given map.
}
\details{
This function allows users to test multiple parameter settings of
\code{redist.mcmc} in preparation for a longer run for analysis.
}
\examples{
\dontrun{
data(algdat.pfull)

## Code to run the simulations in Figure 4 in Fifield, Higgins, Imai and
## Tarr (2015)

## Get an initial partition
set.seed(1)
initcds <- algdat.pfull$cdmat[,sample(1:ncol(algdat.pfull$cdmat), 1)]

params <- expand.grid(eprob = c(.01, .05, .1))

## Run the algorithm
redist.findparams(adjobj = algdat.pfull$adjlist,
popvec = algdat.pfull$precinct.data$pop,
initcds = initcds, nsims = 10000, params = params)
}
}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander
Tarr. (2016) "A New Automated Redistricting Simulator Using Markov Chain Monte
Carlo." Working Paper. Available at
\url{http://imai.princeton.edu/research/files/redist.pdf}.
}
