% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preserveProject.R
\name{preserveProject}
\alias{preserveProject}
\alias{preserveProject.redcapApiConnection}
\alias{readPreservedProject}
\alias{readPreservedProject.list}
\alias{readPreservedProject.character}
\title{Preserve Project Data Locally}
\usage{
preserveProject(rcon, ..., save_as = NULL, dir, dir_create = TRUE)

\method{preserveProject}{redcapApiConnection}(
  rcon,
  ...,
  save_as = NULL,
  dir,
  dir_create = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list()
)

readPreservedProject(x, ...)

\method{readPreservedProject}{list}(x, ..., version = NULL, url = NULL)

\method{readPreservedProject}{character}(x, ..., version = NULL, url = NULL)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{...}{arguments to pass to other methods}

\item{save_as}{\code{character(1)} or \code{NULL}. When \code{"Rdata"}, the data objects
will be saved to an .Rdata file.
When \code{"csv"}, the data objects will
be written to files at \code{dir}. Any other character value will prompt an
error.}

\item{dir}{\code{character(1)}. The path to a directory in which the data
objects (or files) will be saved. Must be provided if \code{save_as} is not
\code{NULL}.}

\item{dir_create}{\code{logical(1)}. When \code{TRUE}, an attempt will be made to
create the directory at \code{dir} if it does not already exist. When \code{FALSE},
and the directory does not exist, an error is returned.}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A list to be passed to \code{\link[httr:POST]{httr::POST()}}.  This allows the
user to set additional configurations for the API calls, such as
certificates, SSL version, etc. For the majority of users, this does
not need to be altered.}

\item{x}{\code{list} or \code{character}. If a \code{list}, the list returned (or saved)
by \code{preserveProject}. If \code{character}, the directory to which the
CSV files are saved by \code{preserveProject}.}

\item{version}{\code{character(1)} giving the instance's REDCap version number.}

\item{url}{\code{character(1)}. URL for the user's REDCap database API.}
}
\value{
\subsection{`preserveProject}{

\code{When}save_as = NULL`, returns a list is returned with the elements
\itemize{
\item \code{project_information}
\item \code{arms}
\item \code{events}
\item \code{meta_data}
\item \code{mappings}
\item \code{repeating_instruments}
\item \code{users}
\item \code{user_roles}
\item \code{user_role_assignments}
\item \code{dags}
\item \code{dag_assignments}
\item \code{records}
}

When \code{save_as} is not \code{NULL}, the logical \code{TRUE} is invisibly returned
to provide an indication that the save operation(s) are complete.
}

\subsection{\code{readPreservedProject}}{

Returns a \code{redcapOfflineConnection} object.
}
}
\description{
The methods enable the user to export a project data and
meta data into local memory. For convenience, options are provided
to save the objects to files on the local machine. Files may be
saved as either .Rdata files or .csv files.
}
\details{
The options to save files to local files provide the user a
convenient tool set for providing other users with the ability to work
with data offline. See the examples for suggestions on how to read data
into an \code{offlineConnection}.

When saving to an .Rdata file, the data are saved in a list named
\code{RedcapList}. The list has the same elements in the list returned when
\code{save_as = NULL} and is suitable for creating an \code{offlineConnection}.
The file name it is saved to follows the pattern
\code{"project-[project_id]-RedcapList.Rdata"}.

When saving to a .csv file, each element of the data is saved to a
file with the pattern \code{"project-[project_id]-[data type].csv"}.

\code{readPreservedProject} is a function of convenience for users who
need to work using offline connections. If given a \code{list}, it
must be in the format returned by \code{preserveProject}. If given a
\code{character}, it must be the directory in which the CSV files were
saved by \code{preserveProject}. If any of the file names have been changed,
\code{readPreservedProject} will fail to execute. Refer to
\code{vignette("redcapAPI-offline-connection", package = "redcapAPI")}
for more details.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Save a project to the current session

projectData <- preserveProject(rcon)


# Save a project to an Rdata file

save_to_dir <- tempdir()
preserveProject(rcon, 
                save_as = "Rdata", 
                dir = save_to_dir)

# Create an offline connection from the Rdata file
load(file.path(save_to_dir, 
               "project-[project_id]-RedcapList.Rdata"))

off_conn <- readPreservedProject(RedcapList, 
                                 version = "[redcap_api_version]", 
                                 url = "[redcap_api_url]")
                  
                  
# Save a project to CSV files

save_to_dir <- tempdir()
preserveProject(rcon, 
                save_as = "csv", 
                dir = save_to_dir)
                
# Create an offline connection from the CSV files

off_con <- 
 readPreservedProject(save_to_dir, 
                      version = "[redcap_api_version]", 
                      url = "[redcap_api_url]")
}

  
}
\seealso{
\code{vignette("redcapAPI-offline-connection", package = "redcapAPI")},\cr
\code{\link[=offlineConnection]{offlineConnection()}} \cr
\cr
\code{\link[=purgeProject]{purgeProject()}}, \cr
\code{\link[=restoreProject]{restoreProject()}}
}
