% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRecursionsInPolygon.Move.R,
%   R/getRecursionsInPolygon.R, R/getRecursionsInPolygon.data.frame.R,
%   R/getRecursionsInPolygon.movestack.R
\name{getRecursionsInPolygon.Move}
\alias{getRecursionsInPolygon.Move}
\alias{getRecursionsInPolygon}
\alias{getRecursionsInPolygon.data.frame}
\alias{getRecursionsInPolygon.MoveStack}
\title{Calculates recursion information from the trajectory inside a polygon}
\usage{
\method{getRecursionsInPolygon}{Move}(
  trajectory,
  polygon,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

getRecursionsInPolygon(
  trajectory,
  polygon,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

\method{getRecursionsInPolygon}{data.frame}(
  trajectory,
  polygon,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)

\method{getRecursionsInPolygon}{MoveStack}(
  trajectory,
  polygon,
  threshold = 0,
  timeunits = c("hours", "secs", "mins", "days"),
  verbose = TRUE
)
}
\arguments{
\item{trajectory}{A data frame with four columns (the x-coordinate, the y-coordinate, the datetime, and the animal id).}

\item{polygon}{A \link[sp]{SpatialPolygons} object with a single convex polygon.}

\item{threshold}{A time difference (in units \code{timeunits}) to ignore excursions outside the radius. Defaults to 0.}

\item{timeunits}{Character string specifying units to calculate time differences in for the time spans inside the radius and since the 
visit in \code{revisitStats}. Defaults to hours.}

\item{verbose}{\code{TRUE} to output complete information (can be large for large input data frames) or 
\code{FALSE} to output basic information.}
}
\value{
A list with several components, \code{revisits} and \code{residenceTime}
are vectors of the same length as the \code{trajectory} dataframe. \code{revisits} is the number of revisits for each 
location, where 1 means that there were 
no revisits, only the initial visit. \code{residenceTime} is the total time spent withing the radius. \code{radius}
is the specified radius used for all the calculations. \code{timeunits} is the specified time units used to specify
timespans.

When \code{verbose = TRUE}, additional information 
is also returned, \code{dists} and \code{revisitStats}. Next, \code{dists} gives the distance matrix between
all locations. Finally, \code{revisitStats} gives further statistics on each visit. These are calculated 
per location (i.e., no aggregation of nearby points is performed), and give the index and location
of the point of the track at the center of the radius, the radius entrance and exit time of the track for that 
visit, how much time was spent inside the radius, and how long since the last visit (\code{NA} for the first visit).
}
\description{
The number of  revisits to a polygon is calculated as the number of segments of the trajectory 
passing through the polygon.
}
\details{
The number of segments of the trajectory passing through the polygon is counted as 
the number of revisits. For each  revisit, the time spent inside the polygon is calculated, as 
well as the time since the last visit (NA for the first visit). In order to calculate the time values, 
the crossing time of the polygon is calculated by assuming linear movement at a constant speed between 
the points inside and outside the polygon. Note the polygon must be convex as described in further detail below.

\strong{Projection.} Consider the projection used. Since segments are counted passing through the
polygon, an equal area projection would ensure similar size comparisons (e.g., \link[move]{spTransform}). 
A geographic projection is not appropriate. The projection for the 
polygon and the trajectory must be the same.

\strong{Polygon.} The polygon must be specified as a \link[sp]{SpatialPolygons} object. It should consist
of a single polygon (rather than a list of multiple polygons). It should further be convex, though this
requirement is not enforced, calculations for non-convex polygons will not necessarily be accurate. It may
be advantageous to simplify complex geometry in order to shorten the time to run. If it is necessary to use a
non-convex polygon, one approach would be to split it into convex pieces that can be run one-by-one. However,
some visits would then be double-counted and would need to be combined back together based on the
entrance/exit times and sequence of trajectory locations.

Either single or multiple individuals are supported, but be aware that this function will be slow with
large amounts of data (e.g. millions of points). Multiple individuals are handled via the \code{id} column of the 
data.frame.
}
\section{Methods (by class)}{
\itemize{
\item \code{getRecursionsInPolygon(Move)}: Get recursions in polygon for a \link[move]{Move-class} trajectory

\item \code{getRecursionsInPolygon(data.frame)}: Get recursions inside a polygon for a trajectory data.frame object consisting of columns x, y, datetime, and id

\item \code{getRecursionsInPolygon(MoveStack)}: Get recursions in polygon for a \link[move]{MoveStack} trajectory

}}
\examples{
#data(track)
#poly = sp::SpatialPolygons( list(
#	 	sp::Polygons( list(sp::Polygon(cbind(c(4,6,6,3,4),c(1,2,4,3,1)))), ID = 1 )
#	 	))
#revisits = getRecursionsInPolygon(track, poly)
}
\seealso{
\code{\link{getRecursions}}
}
\author{
Chloe Bracis <cbracis@uw.edu>
}
