% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombinator.R
\name{homogeneous_recombinator}
\alias{homogeneous_recombinator}
\title{Process homogeneous batch data.}
\usage{
homogeneous_recombinator(dat, id = "id")
}
\arguments{
\item{dat}{list. The list of lists to process. The first list element is
a character vector of variable names, and subsequent elements are lists
of variable values ordered by these variable names.}

\item{id}{character. Primary key, by default \code{"id"}.}
}
\value{
the formatted \code{data.frame}
}
\description{
This function turns a list of data obtained from the Avant API in
homogeneous format into a \code{data.frame}. Here, homogeneous refers
to a list of lists with the first element of the list being a character
vector of column names, and subsequent list elements being lists of
values in the correct order and of the same length as the names vector.
}
\details{
For example,
 \code{list(c('variable_one', 'variable_two'), list(1, 'a'), list(2, 'b'))}
refers to a data set with two variables with two rows, the first variable
having \code{c(1,2)} and the latter having \code{'a', 'b'}.

If the list of lists is not formatted in this way, the function performs
no error handling and will likely return a malformed \code{data.frame}.
}
\examples{
pre_dataframe <- list(c('variable_one', 'variable_two'), list(1, 'a'), list(2, 'b'))
df <- homogeneous_recombinator(pre_dataframe)
# 2 by 2 dataframe w/ c(1,2), c('a','b') in the columns, respectively.
}
