% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotorious.R
\name{annotorious}
\alias{annotorious}
\title{Annotate images with areas of interest}
\usage{
annotorious(
  inputId = "annotations",
  src,
  tags = c("Cat", "Dog", "Person", "Other"),
  width = NULL,
  height = NULL,
  elementId = NULL,
  dependencies = NULL
)
}
\arguments{
\item{inputId}{The input slot that will be used to access the value}

\item{src}{character string with the image/url to annotate}

\item{tags}{character vector of possible labels you want to use}

\item{width}{passed on to \code{\link[htmlwidgets]{createWidget}}}

\item{height}{passed on to \code{\link[htmlwidgets]{createWidget}}}

\item{elementId}{passed on to \code{\link[htmlwidgets]{createWidget}}}

\item{dependencies}{passed on to \code{\link[htmlwidgets]{createWidget}}}
}
\value{
An object of class htmlwidget as returned by \code{\link[htmlwidgets]{createWidget}}
that will intelligently print itself into HTML in a variety of contexts including the R console,
within R Markdown documents, and within Shiny output bindings.
}
\description{
Functionality to label areas in images
}
\examples{
url <- "https://www.w3schools.com/images/picture.jpg"
annotorious(src = url)
url <- paste("https://nl.wikipedia.org/wiki/",
             "Hoofdpagina#/media/Bestand:Pamphlet_dutch_tulipomania_1637.jpg")
url <- paste("https://upload.wikimedia.org/",
             "wikipedia/commons/a/a0/Pamphlet_dutch_tulipomania_1637.jpg",
             sep = "")
annotorious(src = url)
annotorious(src = url, tags = c("Image", "Text", "Other"))
}
\seealso{
\code{\link{annotorious-shiny}}
}
