% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pnp}
\alias{pnp}
\title{Check if a point is within a polygon (2D)}
\usage{
pnp(vertx, verty, testx, testy)
}
\arguments{
\item{vertx}{vector of x axis values of polygon corner points}

\item{verty}{vector of y axis values of polygon corner points}

\item{testx}{x axis value of point of interest}

\item{testy}{y axis value of point of interest}
}
\value{
boolean value - TRUE, if the point is within the polygon. Otherwise FALSE.
}
\description{
\code{pnp} is able to determine if a point is within a polygon in 2D space.
The polygon is described by its corner points. The points must be in a correct
drawing order.

Based on this solution:
Copyright (c) 1970-2003, Wm. Randolph Franklin
\url{https://www.ecse.rpi.edu/Homepages/wrf/Research/Short_Notes/pnpoly.html}
}
\details{
For discussion see: \url{http://stackoverflow.com/questions/217578/how-can-i-determine-whether-a-2d-point-is-within-a-polygon/2922778#2922778}
}
\examples{
df <- data.frame(
  x = c(1,1,2,2),
  y = c(1,2,1,2)
)

pnp(df$x, df$y, 1.5, 1.5)
pnp(df$x, df$y, 2.5, 2.5)

# caution: false-negatives in edge-cases:
pnp(df$x, df$y, 2, 1.5)

}
\seealso{
Other pnpfuncs: \code{\link{pnpmulti}}
}

