\name{summary.CaseControlStudy}
\alias{summary}
\alias{summary.CaseControlStudy}

\title{
  Summarize a case-control-study.
}

\description{
  Summarize a case-control-study.
}

\usage{
\method{summary}{CaseControlStudy}( object, \dots )
}

\arguments{
  \item{object}{
    A \code{CaseControlStudy} object as generated by \code{\link{make.case.control.study}}.
  }
  \item{\dots}{
    Generic arguments.
  }
  
}

\author{
  Christian Westphal
}

\seealso{
  \code{\link{rccs}}
}

\examples{
## Set up the PopulationAtRisk:
PaR <- build.population( cancer~smoking+drinking, 5000000, .0001,
c(.2,.2,.1), c(2,5,10) )

## Generate a random case-control study from it:
ccs <- rccs(PaR, 5, TRUE, TRUE)

## Summarize the case-control study:
summary(ccs)
}

\keyword{ utilities }

