% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency.R
\name{consistencytest}
\alias{consistencytest}
\title{Consistency Tests for the Abundance Estimator, Partial Stratification}
\usage{
consistencytest(
  n1,
  n2,
  m2strata1 = NULL,
  m2strata2 = NULL,
  stratamat = NULL,
  ...
)
}
\arguments{
\item{n1}{A vector of the total sample sizes in the first event, by
strata.  For example, setting \code{n1=c(20,30,40)} would imply 20
individuals captured and marked in stratum 1, 30 in stratum 2, and 40 in
stratum 3.}

\item{n2}{A vector of the total sample sizes in the second event, by
strata.}

\item{m2strata1}{A vector of the first-event stratum membership of each
recaptured individual.  Only values \code{1, 2, 3, ...} are allowed.  May
be used together with \code{m2strata2} instead of \code{stratamat}.}

\item{m2strata2}{A vector of the second-event stratum membership of each
recaptured individual.  Only values \code{1, 2, 3, ...} are allowed.  May
be used together with \code{m2strata1} instead of \code{stratamat}.}

\item{stratamat}{A matrix specifying the number of recaptures in each
combination of event 1 and event 2 strata, with rows corresponding to event
1 strata and columns corresponding to event 2 strata.  May be used instead
of \code{m2strata1} and \code{m2strata2}.}

\item{...}{Additional arguments for \link[stats]{chisq.test}}
}
\value{
A list of class \code{"recapr_consistencytest"} with the following components:
\itemize{
\item{\code{test1_tab}} {The contingency table used for the first test}
\item{\code{test1_Xsqd}} {The chi-squared test statistic in the first test}
\item{\code{test1_df}} {The associated degrees of freedom in the first test}
\item{\code{test1_pval}} {The p-value returned from the first test}
\item{\code{test2_tab}} {The contingency table used for the second test}
\item{\code{test2_Xsqd}} {The chi-squared test statistic in the second test}
\item{\code{test2_df}} {The associated degrees of freedom in the second test}
\item{\code{test2_pval}} {The p-value returned from the second test}
\item{\code{test3_tab}} {The contingency table used for the third test}
\item{\code{test3_Xsqd}} {The chi-squared test statistic in the third test}
\item{\code{test3_df}} {The associated degrees of freedom in the third test}
\item{\code{test3_pval}} {The p-value returned from the third test}
}
}
\description{
Conducts three chi-squared tests for the consistency of the
  Petersen-type abundance estimator.  These tests explore evidence
  against the second traditional assumption of the Petersen mark-recapture
  experiment: that equal capture probabilities exist in either the first or
  second sampling event, or that complete mixing occurs between events.

  Typically, if any of these test p-values is greater than the significance
  level, use of a Petersen-type estimator is considered justified.  If all
  three tests give p-values below the significance level and no movement
  occurs between strata (and strata are the same between events), a
  stratified estimator may be used. If all three tests give p-values below
  the significance level and some movement between strata occurs, a partially
  stratified (Darroch-type) estimator must be used, such as \link{NDarroch}.

  This function assumes stratification in both sampling events, and in
  different ways (by time, area, etc.)  If stratification was the same in
  both events such that individuals could not move from one strata to another
  (such as by size or gender), use of \link{strattest} is recommended.
}
\note{
Naming conventions for the second and third tests are taken from SPAS (see reference)

Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
consistencytest(n1=c(15,12,6), n2=c(12,9,10,8),
   m2strata1=c(1,1,1,1,1,2,2,2,3,3),
   m2strata2=c(1,1,3,3,4,1,2,4,1,3),
   simulate.p.value=TRUE)

mat <- matrix(c(30,15,1,0,22,15), nrow=2, ncol=3, byrow=TRUE)
consistencytest(n1=c(284,199), n2=c(347,3616,1489), stratamat=mat)
}
\references{
Stratified Population Analysis System (Arnason, A.N., C.W. Kirby, C.J. Schwarz
 and J.R. Irvine. 1996. Computer Analysis of Data from Stratified Mark-Recovery Experiments
 for Estimation of Salmon Escapements and Other Populations, Canadian Technical Report of
 Fisheries and Aquatic Sciences 2106).
}
\seealso{
\link{strattest}, \link{NDarroch}
}
\author{
Matt Tyers
}
