% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-classes.R
\name{IsoClasses}
\alias{IsoClasses}
\alias{IsoDateTime}
\alias{iso_date}
\alias{iso_datetime}
\alias{iso_time}
\title{ISO 8601 date-time classes}
\usage{
iso_date(lo, hi, char_class = TRUE)

iso_time(lo, hi, char_class = TRUE)

iso_datetime(lo, hi, char_class = TRUE)
}
\arguments{
\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{char_class}{\code{TRUE} or \code{FALSE}. Should the values be wrapped
into a character class?}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match ISO 8601 date and time classes.
}
\examples{
iso_date()
iso_time()
iso_datetime()

# With repetition
iso_date(3, 6)
iso_time(1, Inf)
iso_datetime(0, Inf)

# Without a class wrapper
iso_date(char_class = FALSE)
}
\references{
\url{http://www.iso.org/iso/iso8601}
}

