% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{Anchors}
\alias{Anchors}
\alias{END}
\alias{START}
\title{The start or end of a string.}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
START

END
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match the start or end of a string.
}
\note{
Caret and dollar are used as start/end delimiters, since \code{\\A} and
\code{\\Z} are not supported by R's internal PRCE engine or \code{stringi}'s
ICU engine.
}
\examples{
START
END

# Usage
x <- c("catfish", "tomcat")
(rx_start <- START \%R\% "cat")
(rx_end <- "cat" \%R\% END)
stringi::stri_detect_regex(x, rx_start)
stringi::stri_detect_regex(x, rx_end)
}
\references{
\url{http://www.regular-expressions.info/anchors.html} and
\url{http://www.rexegg.com/regex-anchors.html}
}
\seealso{
\code{\link{exactly}} and \code{\link{modify_mode}}
}
\keyword{datasets}

