% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutators.R
\name{multi_mutator_}
\alias{multi_mutator_}
\title{Wrapper for running multi-column mutator methods}
\usage{
multi_mutator_(
  data,
  mutate_fn,
  check_fn,
  cols = NULL,
  suffix = "_mutated",
  overwrite = FALSE,
  force_df = TRUE,
  allowed_types = c("numeric", "factor"),
  allow_missing = FALSE,
  min_dims = 1,
  altered_col = NULL,
  keep_original = TRUE,
  origin_fn = NULL,
  ...
)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{mutate_fn}{Mutator to apply.}

\item{check_fn}{Function with checks post-preparation of \code{`data`} and \code{`col(s)`}.
Should not return anything.}

\item{cols}{Columns to mutate values of. Must be specified when \code{`data`} is a \code{data.frame}.}

\item{suffix}{Suffix to add to the names of the generated columns.

Use an empty string (i.e. \code{""}) to overwrite the original columns.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}

\item{force_df}{Whether to return a \code{data.frame} when \code{`data`} is a \code{vector}.}

\item{allowed_types}{Allowed types of the \code{`col(s)`} columns. The type restrictions do not apply to
columns not mentioned in the \code{`col(s)`} argument.}

\item{allow_missing}{Whether to allow missing values (\code{NA}s). (Logical)}

\item{min_dims}{Minimum number of dimensions (cols) after preparations. When \code{`data`} is a \code{vector}
setting \code{`min_dims`} to \code{2} will use both the index and the values as columns.}

\item{altered_col}{Additional column that is mutated but is not
mentioned in \code{`cols`}.}

\item{keep_original}{Whether to keep the original columns. (Logical)

Some columns may have been overwritten, in which case only the newest versions are returned.}

\item{origin_fn}{Function for finding the origin coordinates.

\strong{Input}: Each column will be passed as a \code{vector} in the order of \code{`cols`}.

\strong{Output}: A \code{vector} with one scalar per dimension.

Can be created with \code{\link[rearrr:create_origin_fn]{create_origin_fn()}} if you want to apply
the same function to each dimension.

E.g. \code{`create_origin_fn(median)`} would find the median of each column.

\strong{Built-in functions} are \code{\link[rearrr:centroid]{centroid()}},
\code{\link[rearrr:most_centered]{most_centered()}},
and \code{\link[rearrr:midrange]{midrange()}}}

\item{...}{Named arguments for the \code{`mutate_fn`}.}
}
\value{
The mutated \code{data.frame} (\code{tibble}).
}
\description{
Wrapper for running multi-column mutator methods
}
\keyword{internal}
