% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_surveyxact.R
\name{read_surveyxact}
\alias{read_surveyxact}
\title{Import Data Generated by SurveyXact}
\usage{
read_surveyxact(
  filepath = c(dataset = "dataset.csv", structure = "structure.csv", labels =
    "labels.csv"),
  trim_ws = FALSE
)
}
\arguments{
\item{filepath}{A character string with a path to an Excel file, or a character vector with paths to the dataset.csv, structure.csv and labels.csv-files.}

\item{trim_ws}{Logical, default is FALSE. Whether to remove
leading and ending whitespace from all files.}
}
\value{
data.frame.
}
\description{
First export the data from SurveyXact either as Excel or a set of CSV-files
in European format (semicolon-sep). Then import using this function while
setting variable labels and value labels automatically. Can then use
labelled-package or other functions in this package for
further processing.
}
\examples{
dataset <- system.file("extdata", "ex_survey2_tab_utf16", "dataset.csv",
  package = "readSX", mustWork = TRUE
)
labels <- system.file("extdata", "ex_survey2_tab_utf16", "labels.csv",
  package = "readSX", mustWork = TRUE
)
structure <- system.file("extdata", "ex_survey2_tab_utf16", "structure.csv",
  package = "readSX", mustWork = TRUE
)
ex_survey2_tab_utf16 <-
  read_surveyxact(filepath = c(
    dataset = dataset,
    labels = labels,
    structure = structure
  ))
}
