% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/readGenalex.R
\name{printGenotype}
\alias{printGenotype}
\alias{printGenotype.genalex}
\title{Print selected genotypes}
\usage{
\method{printGenotype}{genalex}(x, rows = 1:nrow(x), callout.locus = NULL,
  sep = " ", allele.sep = "/", callout.char = "*", label = NULL, ...)
}
\arguments{
\item{x}{An annotated data frame of class \code{'genalex'}}

\item{rows}{The specific rows of \code{x} to print, default is
       all rows}

\item{callout.locus}{One or more loci on \code{x} to be surrounded by
       \code{callout.char} when printed}

\item{sep}{Separator character to be used between loci}

\item{allele.sep}{Separator character to be used between alleles}

\item{callout.char}{Character which surrounds loci specified by
       \code{callout.locus}}

\item{label}{Label to be included between the sample and population ID
       columns and the genotype columns in output}

\item{\dots}{Additional arguments, currently ignored}
}
\value{
No specific return value, used for its side effect of printing
        genotypes.
}
\description{
Print selected genotypes, optionally calling out a locus
}
\examples{
data(Qagr_adult_genotypes)
printGenotype(Qagr_adult_genotypes, rows = 6:8, callout.locus = "1c08")
}
\author{
Douglas G. Scofield
}

